/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.yaml.swapper;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.api.config.sharding.TableRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlTableRuleConfiguration;
import org.apache.shardingsphere.core.yaml.swapper.KeyGeneratorConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.ShardingStrategyConfigurationYamlSwapper;
import org.apache.shardingsphere.underlying.common.yaml.swapper.YamlSwapper;

public final class TableRuleConfigurationYamlSwapper
implements YamlSwapper<YamlTableRuleConfiguration, TableRuleConfiguration> {
    private final ShardingStrategyConfigurationYamlSwapper shardingStrategyConfigurationYamlSwapper = new ShardingStrategyConfigurationYamlSwapper();
    private final KeyGeneratorConfigurationYamlSwapper keyGeneratorConfigurationYamlSwapper = new KeyGeneratorConfigurationYamlSwapper();

    public YamlTableRuleConfiguration swap(TableRuleConfiguration data) {
        YamlTableRuleConfiguration result = new YamlTableRuleConfiguration();
        result.setLogicTable(data.getLogicTable());
        result.setActualDataNodes(data.getActualDataNodes());
        if (null != data.getDatabaseShardingStrategyConfig()) {
            result.setDatabaseStrategy(this.shardingStrategyConfigurationYamlSwapper.swap(data.getDatabaseShardingStrategyConfig()));
        }
        if (null != data.getTableShardingStrategyConfig()) {
            result.setTableStrategy(this.shardingStrategyConfigurationYamlSwapper.swap(data.getTableShardingStrategyConfig()));
        }
        if (null != data.getKeyGeneratorConfig()) {
            result.setKeyGenerator(this.keyGeneratorConfigurationYamlSwapper.swap(data.getKeyGeneratorConfig()));
        }
        return result;
    }

    public TableRuleConfiguration swap(YamlTableRuleConfiguration yamlConfiguration) {
        Preconditions.checkNotNull((Object)yamlConfiguration.getLogicTable(), (Object)"Logic table cannot be null.");
        TableRuleConfiguration result = new TableRuleConfiguration(yamlConfiguration.getLogicTable(), yamlConfiguration.getActualDataNodes());
        if (null != yamlConfiguration.getDatabaseStrategy()) {
            result.setDatabaseShardingStrategyConfig(this.shardingStrategyConfigurationYamlSwapper.swap(yamlConfiguration.getDatabaseStrategy()));
        }
        if (null != yamlConfiguration.getTableStrategy()) {
            result.setTableShardingStrategyConfig(this.shardingStrategyConfigurationYamlSwapper.swap(yamlConfiguration.getTableStrategy()));
        }
        if (null != yamlConfiguration.getKeyGenerator()) {
            result.setKeyGeneratorConfig(this.keyGeneratorConfigurationYamlSwapper.swap(yamlConfiguration.getKeyGenerator()));
        }
        return result;
    }
}

