/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.yaml.swapper;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collections;
import org.apache.shardingsphere.core.rule.ProxyUser;
import org.apache.shardingsphere.core.yaml.config.common.YamlProxyUserConfiguration;
import org.apache.shardingsphere.underlying.common.yaml.swapper.YamlSwapper;

public final class ProxyUserYamlSwapper
implements YamlSwapper<YamlProxyUserConfiguration, ProxyUser> {
    public YamlProxyUserConfiguration swap(ProxyUser data) {
        YamlProxyUserConfiguration result = new YamlProxyUserConfiguration();
        result.setPassword(data.getPassword());
        String authorizedSchemas = null == data.getAuthorizedSchemas() ? "" : Joiner.on((char)',').join(data.getAuthorizedSchemas());
        result.setAuthorizedSchemas(authorizedSchemas);
        return result;
    }

    public ProxyUser swap(YamlProxyUserConfiguration yamlConfiguration) {
        if (Strings.isNullOrEmpty((String)yamlConfiguration.getAuthorizedSchemas())) {
            return new ProxyUser(yamlConfiguration.getPassword(), Collections.emptyList());
        }
        return new ProxyUser(yamlConfiguration.getPassword(), Splitter.on((char)',').trimResults().splitToList((CharSequence)yamlConfiguration.getAuthorizedSchemas()));
    }
}

