/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.strategy.route.inline;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.util.Expando;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.shardingsphere.api.config.sharding.strategy.InlineShardingStrategyConfiguration;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.core.strategy.route.ShardingStrategy;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RangeRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.underlying.common.config.inline.InlineExpressionParser;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationPropertyKey;

public final class InlineShardingStrategy
implements ShardingStrategy {
    private final String shardingColumn;
    private final Closure<?> closure;

    public InlineShardingStrategy(InlineShardingStrategyConfiguration inlineShardingStrategyConfig) {
        Preconditions.checkNotNull((Object)inlineShardingStrategyConfig.getShardingColumn(), (Object)"Sharding column cannot be null.");
        Preconditions.checkNotNull((Object)inlineShardingStrategyConfig.getAlgorithmExpression(), (Object)"Sharding algorithm expression cannot be null.");
        this.shardingColumn = inlineShardingStrategyConfig.getShardingColumn();
        String algorithmExpression = InlineExpressionParser.handlePlaceHolder((String)inlineShardingStrategyConfig.getAlgorithmExpression().trim());
        this.closure = new InlineExpressionParser(algorithmExpression).evaluateClosure();
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<RouteValue> shardingValues, ConfigurationProperties properties) {
        RouteValue shardingValue = shardingValues.iterator().next();
        if (((Boolean)properties.getValue((Enum)ConfigurationPropertyKey.ALLOW_RANGE_QUERY_WITH_INLINE_SHARDING)).booleanValue() && shardingValue instanceof RangeRouteValue) {
            return availableTargetNames;
        }
        Preconditions.checkState((boolean)(shardingValue instanceof ListRouteValue), (Object)("Inline strategy cannot support this type sharding:" + shardingValue.toString()));
        Collection<String> shardingResult = this.doSharding((ListRouteValue)shardingValue);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String each : shardingResult) {
            if (!availableTargetNames.contains(each)) continue;
            result.add(each);
        }
        return result;
    }

    private Collection<String> doSharding(ListRouteValue shardingValue) {
        LinkedList<String> result = new LinkedList<String>();
        for (PreciseShardingValue each : this.transferToPreciseShardingValues(shardingValue)) {
            result.add(this.execute(each));
        }
        return result;
    }

    private List<PreciseShardingValue> transferToPreciseShardingValues(ListRouteValue<?> shardingValue) {
        ArrayList<PreciseShardingValue> result = new ArrayList<PreciseShardingValue>(shardingValue.getValues().size());
        for (Comparable each : shardingValue.getValues()) {
            result.add(new PreciseShardingValue(shardingValue.getTableName(), shardingValue.getColumnName(), each));
        }
        return result;
    }

    private String execute(PreciseShardingValue shardingValue) {
        Closure result = this.closure.rehydrate((Object)new Expando(), null, null);
        result.setResolveStrategy(3);
        result.setProperty(this.shardingColumn, (Object)shardingValue.getValue());
        return result.call().toString();
    }

    @Override
    public Collection<String> getShardingColumns() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.add(this.shardingColumn);
        return result;
    }
}

