/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.strategy.route.hint;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.api.config.sharding.strategy.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.api.sharding.hint.HintShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.hint.HintShardingValue;
import org.apache.shardingsphere.core.strategy.route.ShardingStrategy;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;

public final class HintShardingStrategy
implements ShardingStrategy {
    private final Collection<String> shardingColumns;
    private final HintShardingAlgorithm shardingAlgorithm;

    public HintShardingStrategy(HintShardingStrategyConfiguration hintShardingStrategyConfig) {
        Preconditions.checkNotNull((Object)hintShardingStrategyConfig.getShardingAlgorithm(), (Object)"Sharding algorithm cannot be null.");
        this.shardingColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.shardingAlgorithm = hintShardingStrategyConfig.getShardingAlgorithm();
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<RouteValue> shardingValues, ConfigurationProperties properties) {
        ListRouteValue shardingValue = (ListRouteValue)shardingValues.iterator().next();
        Collection shardingResult = this.shardingAlgorithm.doSharding(availableTargetNames, new HintShardingValue(shardingValue.getTableName(), shardingValue.getColumnName(), shardingValue.getValues()));
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    @Override
    @Generated
    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }
}

