/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rule;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.api.config.sharding.KeyGeneratorConfiguration;
import org.apache.shardingsphere.api.config.sharding.TableRuleConfiguration;
import org.apache.shardingsphere.core.rule.ShardingDataSourceNames;
import org.apache.shardingsphere.core.strategy.route.ShardingStrategy;
import org.apache.shardingsphere.core.strategy.route.ShardingStrategyFactory;
import org.apache.shardingsphere.core.strategy.route.none.NoneShardingStrategy;
import org.apache.shardingsphere.spi.algorithm.keygen.ShardingKeyGeneratorServiceLoader;
import org.apache.shardingsphere.spi.keygen.ShardingKeyGenerator;
import org.apache.shardingsphere.underlying.common.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.underlying.common.config.inline.InlineExpressionParser;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;
import org.apache.shardingsphere.underlying.common.rule.DataNode;

public final class TableRule {
    private final String logicTable;
    private final List<DataNode> actualDataNodes;
    private final Set<String> actualTables;
    private final Map<DataNode, Integer> dataNodeIndexMap;
    private final ShardingStrategy databaseShardingStrategy;
    private final ShardingStrategy tableShardingStrategy;
    private final String generateKeyColumn;
    private final ShardingKeyGenerator shardingKeyGenerator;
    private final Collection<String> actualDatasourceNames = new LinkedHashSet<String>();
    private final Map<String, Collection<String>> datasourceToTablesMap = new HashMap<String, Collection<String>>();

    public TableRule(String defaultDataSourceName, String logicTableName) {
        this.logicTable = logicTableName.toLowerCase();
        this.actualDataNodes = Collections.singletonList(new DataNode(defaultDataSourceName, logicTableName));
        this.actualTables = this.getActualTables();
        this.cacheActualDatasourcesAndTables();
        this.dataNodeIndexMap = Collections.emptyMap();
        this.databaseShardingStrategy = null;
        this.tableShardingStrategy = null;
        this.generateKeyColumn = null;
        this.shardingKeyGenerator = null;
    }

    public TableRule(Collection<String> dataSourceNames, String logicTableName) {
        this.logicTable = logicTableName.toLowerCase();
        this.dataNodeIndexMap = new HashMap<DataNode, Integer>(dataSourceNames.size(), 1.0f);
        this.actualDataNodes = this.generateDataNodes(logicTableName, dataSourceNames);
        this.actualTables = this.getActualTables();
        this.databaseShardingStrategy = null;
        this.tableShardingStrategy = null;
        this.generateKeyColumn = null;
        this.shardingKeyGenerator = null;
    }

    public TableRule(TableRuleConfiguration tableRuleConfig, ShardingDataSourceNames shardingDataSourceNames, String defaultGenerateKeyColumn) {
        this.logicTable = tableRuleConfig.getLogicTable().toLowerCase();
        List dataNodes = new InlineExpressionParser(tableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        this.dataNodeIndexMap = new HashMap<DataNode, Integer>(dataNodes.size(), 1.0f);
        this.actualDataNodes = this.isEmptyDataNodes(dataNodes) ? this.generateDataNodes(tableRuleConfig.getLogicTable(), shardingDataSourceNames.getDataSourceNames()) : this.generateDataNodes(dataNodes, shardingDataSourceNames.getDataSourceNames());
        this.actualTables = this.getActualTables();
        this.databaseShardingStrategy = null == tableRuleConfig.getDatabaseShardingStrategyConfig() ? null : ShardingStrategyFactory.newInstance(tableRuleConfig.getDatabaseShardingStrategyConfig());
        this.tableShardingStrategy = null == tableRuleConfig.getTableShardingStrategyConfig() ? null : ShardingStrategyFactory.newInstance(tableRuleConfig.getTableShardingStrategyConfig());
        KeyGeneratorConfiguration keyGeneratorConfiguration = tableRuleConfig.getKeyGeneratorConfig();
        this.generateKeyColumn = null != keyGeneratorConfiguration && !Strings.isNullOrEmpty((String)keyGeneratorConfiguration.getColumn()) ? keyGeneratorConfiguration.getColumn() : defaultGenerateKeyColumn;
        this.shardingKeyGenerator = this.containsKeyGeneratorConfiguration(tableRuleConfig) ? (ShardingKeyGenerator)new ShardingKeyGeneratorServiceLoader().newService(tableRuleConfig.getKeyGeneratorConfig().getType(), tableRuleConfig.getKeyGeneratorConfig().getProperties()) : null;
        this.checkRule(dataNodes);
    }

    private void cacheActualDatasourcesAndTables() {
        for (DataNode each : this.actualDataNodes) {
            this.actualDatasourceNames.add(each.getDataSourceName());
            this.addActualTable(each.getDataSourceName(), each.getTableName());
        }
    }

    private Set<String> getActualTables() {
        return this.actualDataNodes.stream().map(DataNode::getTableName).collect(Collectors.toSet());
    }

    private void addActualTable(String datasourceName, String tableName) {
        this.datasourceToTablesMap.computeIfAbsent(datasourceName, k -> new LinkedHashSet()).add(tableName);
    }

    private boolean containsKeyGeneratorConfiguration(TableRuleConfiguration tableRuleConfiguration) {
        return null != tableRuleConfiguration.getKeyGeneratorConfig() && !Strings.isNullOrEmpty((String)tableRuleConfiguration.getKeyGeneratorConfig().getType());
    }

    private boolean isEmptyDataNodes(List<String> dataNodes) {
        return null == dataNodes || dataNodes.isEmpty();
    }

    private List<DataNode> generateDataNodes(String logicTable, Collection<String> dataSourceNames) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        int index = 0;
        for (String each : dataSourceNames) {
            DataNode dataNode = new DataNode(each, logicTable);
            result.add(dataNode);
            this.dataNodeIndexMap.put(dataNode, index);
            this.actualDatasourceNames.add(each);
            this.addActualTable(dataNode.getDataSourceName(), dataNode.getTableName());
            ++index;
        }
        return result;
    }

    private List<DataNode> generateDataNodes(List<String> actualDataNodes, Collection<String> dataSourceNames) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        int index = 0;
        for (String each : actualDataNodes) {
            DataNode dataNode = new DataNode(each);
            if (!dataSourceNames.contains(dataNode.getDataSourceName())) {
                throw new ShardingSphereException("Cannot find data source in sharding rule, invalid actual data node is: '%s'", new Object[]{each});
            }
            result.add(dataNode);
            this.dataNodeIndexMap.put(dataNode, index);
            this.actualDatasourceNames.add(dataNode.getDataSourceName());
            this.addActualTable(dataNode.getDataSourceName(), dataNode.getTableName());
            ++index;
        }
        return result;
    }

    public Map<String, List<DataNode>> getDataNodeGroups() {
        LinkedHashMap<String, List<DataNode>> result = new LinkedHashMap<String, List<DataNode>>(this.actualDataNodes.size(), 1.0f);
        for (DataNode each : this.actualDataNodes) {
            String dataSourceName = each.getDataSourceName();
            if (!result.containsKey(dataSourceName)) {
                result.put(dataSourceName, new LinkedList());
            }
            ((List)result.get(dataSourceName)).add(each);
        }
        return result;
    }

    public Collection<String> getActualDatasourceNames() {
        return this.actualDatasourceNames;
    }

    public Collection<String> getActualTableNames(String targetDataSource) {
        return this.datasourceToTablesMap.getOrDefault(targetDataSource, Collections.emptySet());
    }

    int findActualTableIndex(String dataSourceName, String actualTableName) {
        return this.dataNodeIndexMap.getOrDefault(new DataNode(dataSourceName, actualTableName), -1);
    }

    boolean isExisted(String actualTableName) {
        return this.actualTables.contains(actualTableName);
    }

    private void checkRule(List<String> dataNodes) {
        if (this.isEmptyDataNodes(dataNodes) && null != this.tableShardingStrategy && !(this.tableShardingStrategy instanceof NoneShardingStrategy)) {
            throw new ShardingSphereConfigurationException("ActualDataNodes must be configured if want to shard tables for logicTable [%s]", new Object[]{this.logicTable});
        }
    }

    public Optional<String> getGenerateKeyColumn() {
        return Optional.ofNullable(this.generateKeyColumn);
    }

    @Generated
    public String getLogicTable() {
        return this.logicTable;
    }

    @Generated
    public List<DataNode> getActualDataNodes() {
        return this.actualDataNodes;
    }

    @Generated
    public ShardingStrategy getDatabaseShardingStrategy() {
        return this.databaseShardingStrategy;
    }

    @Generated
    public ShardingStrategy getTableShardingStrategy() {
        return this.tableShardingStrategy;
    }

    @Generated
    public ShardingKeyGenerator getShardingKeyGenerator() {
        return this.shardingKeyGenerator;
    }

    @Generated
    public Map<String, Collection<String>> getDatasourceToTablesMap() {
        return this.datasourceToTablesMap;
    }

    @Generated
    public String toString() {
        return "TableRule(logicTable=" + this.getLogicTable() + ", actualDataNodes=" + this.getActualDataNodes() + ", databaseShardingStrategy=" + this.getDatabaseShardingStrategy() + ", tableShardingStrategy=" + this.getTableShardingStrategy() + ", generateKeyColumn=" + this.getGenerateKeyColumn() + ", shardingKeyGenerator=" + this.getShardingKeyGenerator() + ")";
    }
}

