/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.KeyGeneratorConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.TableRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.strategy.ShardingStrategyConfiguration;
import org.apache.shardingsphere.core.rule.BindingTableRule;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.core.rule.ShardingDataSourceNames;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.core.strategy.route.ShardingStrategy;
import org.apache.shardingsphere.core.strategy.route.ShardingStrategyFactory;
import org.apache.shardingsphere.core.strategy.route.none.NoneShardingStrategy;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.spi.algorithm.keygen.ShardingKeyGeneratorServiceLoader;
import org.apache.shardingsphere.spi.keygen.ShardingKeyGenerator;
import org.apache.shardingsphere.underlying.common.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.underlying.common.rule.BaseRule;
import org.apache.shardingsphere.underlying.common.rule.DataNode;

public class ShardingRule
implements BaseRule {
    private final ShardingRuleConfiguration ruleConfiguration;
    private final ShardingDataSourceNames shardingDataSourceNames;
    private final Collection<TableRule> tableRules;
    private final Collection<BindingTableRule> bindingTableRules;
    private final Collection<String> broadcastTables;
    private final ShardingStrategy defaultDatabaseShardingStrategy;
    private final ShardingStrategy defaultTableShardingStrategy;
    private final ShardingKeyGenerator defaultShardingKeyGenerator;
    private final Collection<MasterSlaveRule> masterSlaveRules;
    private final EncryptRule encryptRule;

    public ShardingRule(ShardingRuleConfiguration shardingRuleConfig, Collection<String> dataSourceNames) {
        Preconditions.checkArgument((null != shardingRuleConfig ? 1 : 0) != 0, (Object)"ShardingRuleConfig cannot be null.");
        Preconditions.checkArgument((null != dataSourceNames && !dataSourceNames.isEmpty() ? 1 : 0) != 0, (Object)"Data sources cannot be empty.");
        this.ruleConfiguration = shardingRuleConfig;
        this.shardingDataSourceNames = new ShardingDataSourceNames(shardingRuleConfig, dataSourceNames);
        this.tableRules = this.createTableRules(shardingRuleConfig);
        this.broadcastTables = shardingRuleConfig.getBroadcastTables();
        this.bindingTableRules = this.createBindingTableRules(shardingRuleConfig.getBindingTableGroups());
        this.defaultDatabaseShardingStrategy = this.createDefaultShardingStrategy(shardingRuleConfig.getDefaultDatabaseShardingStrategyConfig());
        this.defaultTableShardingStrategy = this.createDefaultShardingStrategy(shardingRuleConfig.getDefaultTableShardingStrategyConfig());
        this.defaultShardingKeyGenerator = this.createDefaultKeyGenerator(shardingRuleConfig.getDefaultKeyGeneratorConfig());
        this.masterSlaveRules = this.createMasterSlaveRules(shardingRuleConfig.getMasterSlaveRuleConfigs());
        this.encryptRule = this.createEncryptRule(shardingRuleConfig.getEncryptRuleConfig());
    }

    private Collection<TableRule> createTableRules(ShardingRuleConfiguration shardingRuleConfig) {
        return shardingRuleConfig.getTableRuleConfigs().stream().map(each -> new TableRule((TableRuleConfiguration)each, this.shardingDataSourceNames, this.getDefaultGenerateKeyColumn(shardingRuleConfig))).collect(Collectors.toList());
    }

    private String getDefaultGenerateKeyColumn(ShardingRuleConfiguration shardingRuleConfig) {
        return Optional.ofNullable(shardingRuleConfig.getDefaultKeyGeneratorConfig()).map(KeyGeneratorConfiguration::getColumn).orElse(null);
    }

    private Collection<BindingTableRule> createBindingTableRules(Collection<String> bindingTableGroups) {
        return bindingTableGroups.stream().map(this::createBindingTableRule).collect(Collectors.toList());
    }

    private BindingTableRule createBindingTableRule(String bindingTableGroup) {
        List tableRules = Splitter.on((String)",").trimResults().splitToList((CharSequence)bindingTableGroup).stream().map(this::getTableRule).collect(Collectors.toCollection(LinkedList::new));
        return new BindingTableRule(tableRules);
    }

    private ShardingStrategy createDefaultShardingStrategy(ShardingStrategyConfiguration shardingStrategyConfiguration) {
        return Optional.ofNullable(shardingStrategyConfiguration).map(ShardingStrategyFactory::newInstance).orElse(new NoneShardingStrategy());
    }

    private ShardingKeyGenerator createDefaultKeyGenerator(KeyGeneratorConfiguration keyGeneratorConfiguration) {
        ShardingKeyGeneratorServiceLoader serviceLoader = new ShardingKeyGeneratorServiceLoader();
        return this.containsKeyGeneratorConfiguration(keyGeneratorConfiguration) ? (ShardingKeyGenerator)serviceLoader.newService(keyGeneratorConfiguration.getType(), keyGeneratorConfiguration.getProperties()) : (ShardingKeyGenerator)serviceLoader.newService();
    }

    private boolean containsKeyGeneratorConfiguration(KeyGeneratorConfiguration keyGeneratorConfiguration) {
        return null != keyGeneratorConfiguration && !Strings.isNullOrEmpty((String)keyGeneratorConfiguration.getType());
    }

    private Collection<MasterSlaveRule> createMasterSlaveRules(Collection<MasterSlaveRuleConfiguration> masterSlaveRuleConfigurations) {
        return masterSlaveRuleConfigurations.stream().map(MasterSlaveRule::new).collect(Collectors.toList());
    }

    private EncryptRule createEncryptRule(EncryptRuleConfiguration encryptRuleConfig) {
        return Optional.ofNullable(encryptRuleConfig).map(e -> new EncryptRule(this.ruleConfiguration.getEncryptRuleConfig())).orElse(new EncryptRule());
    }

    public Optional<TableRule> findTableRule(String logicTableName) {
        return this.tableRules.stream().filter(each -> each.getLogicTable().equalsIgnoreCase(logicTableName)).findFirst();
    }

    public Optional<TableRule> findTableRuleByActualTable(String actualTableName) {
        return this.tableRules.stream().filter(each -> each.isExisted(actualTableName)).findFirst();
    }

    public TableRule getTableRule(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (tableRule.isPresent()) {
            return tableRule.get();
        }
        if (this.isBroadcastTable(logicTableName)) {
            return new TableRule(this.shardingDataSourceNames.getDataSourceNames(), logicTableName);
        }
        if (!Strings.isNullOrEmpty((String)this.shardingDataSourceNames.getDefaultDataSourceName())) {
            return new TableRule(this.shardingDataSourceNames.getDefaultDataSourceName(), logicTableName);
        }
        throw new ShardingSphereConfigurationException("Cannot find table rule and default data source with logic table: '%s'", new Object[]{logicTableName});
    }

    public ShardingStrategy getDatabaseShardingStrategy(TableRule tableRule) {
        return null == tableRule.getDatabaseShardingStrategy() ? this.defaultDatabaseShardingStrategy : tableRule.getDatabaseShardingStrategy();
    }

    public ShardingStrategy getTableShardingStrategy(TableRule tableRule) {
        return null == tableRule.getTableShardingStrategy() ? this.defaultTableShardingStrategy : tableRule.getTableShardingStrategy();
    }

    public boolean isAllBindingTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTableNames);
        if (!bindingTableRule.isPresent()) {
            return false;
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(bindingTableRule.get().getAllLogicTables());
        return !result.isEmpty() && result.containsAll(logicTableNames);
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTableNames) {
        return logicTableNames.stream().map(this::findBindingTableRule).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTableName) {
        return this.bindingTableRules.stream().filter(each -> each.hasLogicTable(logicTableName)).findFirst();
    }

    public boolean isAllBroadcastTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        for (String each : logicTableNames) {
            if (this.isBroadcastTable(each)) continue;
            return false;
        }
        return true;
    }

    public boolean isBroadcastTable(String logicTableName) {
        return this.broadcastTables.stream().anyMatch(each -> each.equalsIgnoreCase(logicTableName));
    }

    public boolean isAllInDefaultDataSource(Collection<String> logicTableNames) {
        if (!this.hasDefaultDataSourceName()) {
            return false;
        }
        for (String each : logicTableNames) {
            if (!this.findTableRule(each).isPresent() && !this.isBroadcastTable(each)) continue;
            return false;
        }
        return !logicTableNames.isEmpty();
    }

    public boolean tableRuleExists(Collection<String> logicTableNames) {
        return logicTableNames.stream().anyMatch(each -> this.findTableRule((String)each).isPresent() || this.isBroadcastTable((String)each));
    }

    public boolean isShardingColumn(String columnName, String tableName) {
        return this.tableRules.stream().anyMatch(each -> each.getLogicTable().equalsIgnoreCase(tableName) && this.isShardingColumn((TableRule)each, columnName));
    }

    private boolean isShardingColumn(TableRule tableRule, String columnName) {
        return this.getDatabaseShardingStrategy(tableRule).getShardingColumns().contains(columnName) || this.getTableShardingStrategy(tableRule).getShardingColumns().contains(columnName);
    }

    public Optional<String> findGenerateKeyColumnName(String logicTableName) {
        return this.tableRules.stream().filter(each -> each.getLogicTable().equalsIgnoreCase(logicTableName) && each.getGenerateKeyColumn().isPresent()).map(TableRule::getGenerateKeyColumn).findFirst().orElse(Optional.empty());
    }

    public Comparable<?> generateKey(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (!tableRule.isPresent()) {
            throw new ShardingSphereConfigurationException("Cannot find strategy for generate keys.", new Object[0]);
        }
        return Optional.ofNullable(tableRule.get().getShardingKeyGenerator()).orElse(this.defaultShardingKeyGenerator).generateKey();
    }

    public Collection<String> getLogicTableNames(String actualTableName) {
        return this.tableRules.stream().filter(each -> each.isExisted(actualTableName)).map(TableRule::getLogicTable).collect(Collectors.toCollection(LinkedList::new));
    }

    public DataNode getDataNode(String logicTableName) {
        TableRule tableRule = this.getTableRule(logicTableName);
        return tableRule.getActualDataNodes().get(0);
    }

    public DataNode getDataNode(String dataSourceName, String logicTableName) {
        TableRule tableRule = this.getTableRule(logicTableName);
        return tableRule.getActualDataNodes().stream().filter(each -> this.shardingDataSourceNames.getDataSourceNames().contains(each.getDataSourceName()) && each.getDataSourceName().equals(dataSourceName)).findFirst().orElseThrow(() -> new ShardingSphereConfigurationException("Cannot find actual data node for data source name: '%s' and logic table name: '%s'", new Object[]{dataSourceName, logicTableName}));
    }

    public boolean hasDefaultDataSourceName() {
        String defaultDataSourceName = this.shardingDataSourceNames.getDefaultDataSourceName();
        return !Strings.isNullOrEmpty((String)defaultDataSourceName);
    }

    public Optional<String> findActualDefaultDataSourceName() {
        String defaultDataSourceName = this.shardingDataSourceNames.getDefaultDataSourceName();
        if (Strings.isNullOrEmpty((String)defaultDataSourceName)) {
            return Optional.empty();
        }
        Optional<String> masterDefaultDataSourceName = this.findMasterDataSourceName(defaultDataSourceName);
        return masterDefaultDataSourceName.isPresent() ? masterDefaultDataSourceName : Optional.of(defaultDataSourceName);
    }

    private Optional<String> findMasterDataSourceName(String masterSlaveRuleName) {
        return this.masterSlaveRules.stream().filter(each -> each.getName().equalsIgnoreCase(masterSlaveRuleName)).map(e -> Optional.of(e.getMasterDataSourceName())).findFirst().orElse(Optional.empty());
    }

    public Optional<MasterSlaveRule> findMasterSlaveRule(String dataSourceName) {
        return this.masterSlaveRules.stream().filter(each -> each.containDataSourceName(dataSourceName)).findFirst();
    }

    public Collection<String> getShardingLogicTableNames(Collection<String> logicTableNames) {
        return logicTableNames.stream().filter(each -> this.findTableRule((String)each).isPresent()).collect(Collectors.toCollection(LinkedList::new));
    }

    public Map<String, String> getLogicAndActualTablesFromBindingTable(String dataSourceName, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.findBindingTableRule(logicTable).ifPresent(bindingTableRule -> result.putAll(bindingTableRule.getLogicAndActualTables(dataSourceName, logicTable, actualTable, availableLogicBindingTables)));
        return result;
    }

    public Collection<BaseRule> toRules() {
        LinkedList<BaseRule> result = new LinkedList<BaseRule>();
        result.add(this);
        if (!this.encryptRule.getEncryptTableNames().isEmpty()) {
            result.add((BaseRule)this.encryptRule);
        }
        result.addAll(this.masterSlaveRules);
        return result;
    }

    @Generated
    public ShardingRuleConfiguration getRuleConfiguration() {
        return this.ruleConfiguration;
    }

    @Generated
    public ShardingDataSourceNames getShardingDataSourceNames() {
        return this.shardingDataSourceNames;
    }

    @Generated
    public Collection<TableRule> getTableRules() {
        return this.tableRules;
    }

    @Generated
    public Collection<BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    @Generated
    public Collection<String> getBroadcastTables() {
        return this.broadcastTables;
    }

    @Generated
    public ShardingStrategy getDefaultDatabaseShardingStrategy() {
        return this.defaultDatabaseShardingStrategy;
    }

    @Generated
    public ShardingStrategy getDefaultTableShardingStrategy() {
        return this.defaultTableShardingStrategy;
    }

    @Generated
    public ShardingKeyGenerator getDefaultShardingKeyGenerator() {
        return this.defaultShardingKeyGenerator;
    }

    @Generated
    public Collection<MasterSlaveRule> getMasterSlaveRules() {
        return this.masterSlaveRules;
    }

    @Generated
    public EncryptRule getEncryptRule() {
        return this.encryptRule;
    }
}

