/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;

public final class ShardingDataSourceNames {
    private final ShardingRuleConfiguration shardingRuleConfig;
    private final Collection<String> dataSourceNames;

    public ShardingDataSourceNames(ShardingRuleConfiguration shardingRuleConfig, Collection<String> rawDataSourceNames) {
        Preconditions.checkArgument((null != shardingRuleConfig ? 1 : 0) != 0, (Object)"can not construct ShardingDataSourceNames with null ShardingRuleConfig");
        this.shardingRuleConfig = shardingRuleConfig;
        this.dataSourceNames = this.getAllDataSourceNames(rawDataSourceNames);
    }

    private Collection<String> getAllDataSourceNames(Collection<String> dataSourceNames) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(dataSourceNames);
        for (MasterSlaveRuleConfiguration each : this.shardingRuleConfig.getMasterSlaveRuleConfigs()) {
            result.remove(each.getMasterDataSourceName());
            result.removeAll(each.getSlaveDataSourceNames());
            result.add(each.getName());
        }
        return result;
    }

    public String getDefaultDataSourceName() {
        return 1 == this.dataSourceNames.size() ? this.dataSourceNames.iterator().next() : this.shardingRuleConfig.getDefaultDataSourceName();
    }

    public String getRawMasterDataSourceName(String dataSourceName) {
        for (MasterSlaveRuleConfiguration each : this.shardingRuleConfig.getMasterSlaveRuleConfigs()) {
            if (!each.getName().equals(dataSourceName)) continue;
            return each.getMasterDataSourceName();
        }
        return dataSourceName;
    }

    public String getRandomDataSourceName() {
        return this.getRandomDataSourceName(this.dataSourceNames);
    }

    public String getRandomDataSourceName(Collection<String> dataSourceNames) {
        return (String)Lists.newArrayList(dataSourceNames).get(ThreadLocalRandom.current().nextInt(dataSourceNames.size()));
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }
}

