/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.log;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.rule.Authentication;
import org.apache.shardingsphere.core.yaml.representer.processor.ShardingTupleProcessorFactory;
import org.apache.shardingsphere.core.yaml.swapper.AuthenticationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.MasterSlaveRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.underlying.common.config.RuleConfiguration;
import org.apache.shardingsphere.underlying.common.yaml.engine.YamlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationLogger.class);

    public static void log(RuleConfiguration ruleConfiguration) {
        if (null == ruleConfiguration) {
            return;
        }
        if (ruleConfiguration instanceof ShardingRuleConfiguration) {
            ConfigurationLogger.log((ShardingRuleConfiguration)ruleConfiguration);
        } else if (ruleConfiguration instanceof MasterSlaveRuleConfiguration) {
            ConfigurationLogger.log((MasterSlaveRuleConfiguration)ruleConfiguration);
        } else if (ruleConfiguration instanceof EncryptRuleConfiguration) {
            ConfigurationLogger.log((EncryptRuleConfiguration)ruleConfiguration);
        }
    }

    private static void log(ShardingRuleConfiguration shardingRuleConfiguration) {
        if (null != shardingRuleConfiguration) {
            ConfigurationLogger.log(shardingRuleConfiguration.getClass().getSimpleName(), YamlEngine.marshal((Object)new ShardingRuleConfigurationYamlSwapper().swap(shardingRuleConfiguration), ShardingTupleProcessorFactory.newInstance()));
        }
    }

    private static void log(MasterSlaveRuleConfiguration masterSlaveRuleConfiguration) {
        if (null != masterSlaveRuleConfiguration) {
            ConfigurationLogger.log(masterSlaveRuleConfiguration.getClass().getSimpleName(), YamlEngine.marshal((Object)new MasterSlaveRuleConfigurationYamlSwapper().swap(masterSlaveRuleConfiguration)));
        }
    }

    private static void log(EncryptRuleConfiguration encryptRuleConfiguration) {
        if (null != encryptRuleConfiguration) {
            ConfigurationLogger.log(encryptRuleConfiguration.getClass().getSimpleName(), YamlEngine.marshal((Object)new EncryptRuleConfigurationYamlSwapper().swap(encryptRuleConfiguration)));
        }
    }

    public static void log(Authentication authenticationConfiguration) {
        if (null != authenticationConfiguration) {
            ConfigurationLogger.log(authenticationConfiguration.getClass().getSimpleName(), YamlEngine.marshal((Object)new AuthenticationYamlSwapper().swap(authenticationConfiguration)));
        }
    }

    public static void log(Properties properties) {
        if (null != properties) {
            ConfigurationLogger.log(properties.getClass().getSimpleName(), YamlEngine.marshal((Object)properties));
        }
    }

    private static void log(String type, String logContent) {
        log.info("{}:\n{}", (Object)type, (Object)logContent);
    }

    @Generated
    private ConfigurationLogger() {
    }
}

