/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.web.controller.search;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.elasticjob.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobEventRdbSearch {
    private static final Logger log = LoggerFactory.getLogger(JobEventRdbSearch.class);
    private static final String TABLE_JOB_EXECUTION_LOG = "JOB_EXECUTION_LOG";
    private static final String TABLE_JOB_STATUS_TRACE_LOG = "JOB_STATUS_TRACE_LOG";
    private static final List<String> FIELDS_JOB_EXECUTION_LOG = Arrays.asList("id", "hostname", "ip", "task_id", "job_name", "execution_source", "sharding_item", "start_time", "complete_time", "is_success", "failure_cause");
    private static final List<String> FIELDS_JOB_STATUS_TRACE_LOG = Arrays.asList("id", "job_name", "original_task_id", "task_id", "slave_id", "source", "execution_type", "sharding_item", "state", "message", "creation_time");
    private final DataSource dataSource;
    private final boolean enable;

    public Result<JobExecutionEvent> findJobExecutionEvents(Condition condition) {
        return new Result<JobExecutionEvent>(this.getEventCount(TABLE_JOB_EXECUTION_LOG, FIELDS_JOB_EXECUTION_LOG, condition), this.getJobExecutionEvents(condition));
    }

    public Result<JobStatusTraceEvent> findJobStatusTraceEvents(Condition condition) {
        return new Result<JobStatusTraceEvent>(this.getEventCount(TABLE_JOB_STATUS_TRACE_LOG, FIELDS_JOB_STATUS_TRACE_LOG, condition), this.getJobStatusTraceEvents(condition));
    }

    private List<JobExecutionEvent> getJobExecutionEvents(Condition condition) {
        LinkedList<JobExecutionEvent> result = new LinkedList<JobExecutionEvent>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = this.createDataPreparedStatement(conn, TABLE_JOB_EXECUTION_LOG, FIELDS_JOB_EXECUTION_LOG, condition);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                JobExecutionEvent jobExecutionEvent = new JobExecutionEvent(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), JobExecutionEvent.ExecutionSource.valueOf((String)resultSet.getString(6)), Integer.parseInt(resultSet.getString(7)), new Date(resultSet.getTimestamp(8).getTime()), resultSet.getTimestamp(9) == null ? null : new Date(resultSet.getTimestamp(9).getTime()), resultSet.getBoolean(10), resultSet.getString(11));
                result.add(jobExecutionEvent);
            }
        }
        catch (SQLException ex) {
            log.error("Fetch JobExecutionEvent from DB error:", (Throwable)ex);
        }
        return result;
    }

    private List<JobStatusTraceEvent> getJobStatusTraceEvents(Condition condition) {
        LinkedList<JobStatusTraceEvent> result = new LinkedList<JobStatusTraceEvent>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = this.createDataPreparedStatement(conn, TABLE_JOB_STATUS_TRACE_LOG, FIELDS_JOB_STATUS_TRACE_LOG, condition);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                JobStatusTraceEvent jobStatusTraceEvent = new JobStatusTraceEvent(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), JobStatusTraceEvent.Source.valueOf((String)resultSet.getString(6)), resultSet.getString(7), resultSet.getString(8), JobStatusTraceEvent.State.valueOf((String)resultSet.getString(9)), resultSet.getString(10), new Date(resultSet.getTimestamp(11).getTime()));
                result.add(jobStatusTraceEvent);
            }
        }
        catch (SQLException ex) {
            log.error("Fetch JobStatusTraceEvent from DB error:", (Throwable)ex);
        }
        return result;
    }

    private int getEventCount(String tableName, Collection<String> tableFields, Condition condition) {
        int result = 0;
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = this.createCountPreparedStatement(conn, tableName, tableFields, condition);
             ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            result = resultSet.getInt(1);
        }
        catch (SQLException ex) {
            log.error("Fetch EventCount from DB error:", (Throwable)ex);
        }
        return result;
    }

    private PreparedStatement createDataPreparedStatement(Connection conn, String tableName, Collection<String> tableFields, Condition condition) throws SQLException {
        String sql = this.buildDataSql(tableName, tableFields, condition);
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        this.setBindValue(preparedStatement, tableFields, condition);
        return preparedStatement;
    }

    private PreparedStatement createCountPreparedStatement(Connection conn, String tableName, Collection<String> tableFields, Condition condition) throws SQLException {
        String sql = this.buildCountSql(tableName, tableFields, condition);
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        this.setBindValue(preparedStatement, tableFields, condition);
        return preparedStatement;
    }

    private String buildDataSql(String tableName, Collection<String> tableFields, Condition condition) {
        StringBuilder sqlBuilder = new StringBuilder();
        String selectSql = this.buildSelect(tableName, tableFields);
        String whereSql = this.buildWhere(tableName, tableFields, condition);
        String orderSql = this.buildOrder(tableFields, condition.getSort(), condition.getOrder());
        String limitSql = this.buildLimit(condition.getPage(), condition.getPerPage());
        sqlBuilder.append(selectSql).append(whereSql).append(orderSql).append(limitSql);
        return sqlBuilder.toString();
    }

    private String buildCountSql(String tableName, Collection<String> tableFields, Condition condition) {
        StringBuilder sqlBuilder = new StringBuilder();
        String selectSql = this.buildSelectCount(tableName);
        String whereSql = this.buildWhere(tableName, tableFields, condition);
        sqlBuilder.append(selectSql).append(whereSql);
        return sqlBuilder.toString();
    }

    private String buildSelectCount(String tableName) {
        return String.format("SELECT COUNT(1) FROM %s", tableName);
    }

    private String buildSelect(String tableName, Collection<String> tableFields) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ");
        for (String each : tableFields) {
            sqlBuilder.append(each).append(",");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(" FROM ").append(tableName);
        return sqlBuilder.toString();
    }

    private String buildWhere(String tableName, Collection<String> tableFields, Condition condition) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" WHERE 1=1");
        if (null != condition.getFields() && !condition.getFields().isEmpty()) {
            for (Map.Entry<String, Object> entry : condition.getFields().entrySet()) {
                String lowerUnderscore = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entry.getKey());
                if (null == entry.getValue() || !tableFields.contains(lowerUnderscore)) continue;
                sqlBuilder.append(" AND ").append(lowerUnderscore).append("=?");
            }
        }
        if (null != condition.getStartTime()) {
            sqlBuilder.append(" AND ").append(this.getTableTimeField(tableName)).append(">=?");
        }
        if (null != condition.getEndTime()) {
            sqlBuilder.append(" AND ").append(this.getTableTimeField(tableName)).append("<=?");
        }
        return sqlBuilder.toString();
    }

    private void setBindValue(PreparedStatement preparedStatement, Collection<String> tableFields, Condition condition) throws SQLException {
        int index = 1;
        if (null != condition.getFields() && !condition.getFields().isEmpty()) {
            for (Map.Entry<String, Object> entry : condition.getFields().entrySet()) {
                String lowerUnderscore = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entry.getKey());
                if (null == entry.getValue() || !tableFields.contains(lowerUnderscore)) continue;
                preparedStatement.setString(index++, String.valueOf(entry.getValue()));
            }
        }
        if (null != condition.getStartTime()) {
            preparedStatement.setTimestamp(index++, new Timestamp(condition.getStartTime().getTime()));
        }
        if (null != condition.getEndTime()) {
            preparedStatement.setTimestamp(index, new Timestamp(condition.getEndTime().getTime()));
        }
    }

    private String getTableTimeField(String tableName) {
        String result = "";
        if (TABLE_JOB_EXECUTION_LOG.equals(tableName)) {
            result = "start_time";
        } else if (TABLE_JOB_STATUS_TRACE_LOG.equals(tableName)) {
            result = "creation_time";
        }
        return result;
    }

    private String buildOrder(Collection<String> tableFields, String sortName, String sortOrder) {
        if (Strings.isNullOrEmpty((String)sortName)) {
            return "";
        }
        String lowerUnderscore = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, sortName);
        if (!tableFields.contains(lowerUnderscore)) {
            return "";
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" ORDER BY ").append(lowerUnderscore);
        if ("DESC".equals(sortOrder.toUpperCase())) {
            sqlBuilder.append(" DESC");
        } else {
            sqlBuilder.append(" ASC");
        }
        return sqlBuilder.toString();
    }

    private String buildLimit(int page, int perPage) {
        StringBuilder sqlBuilder = new StringBuilder();
        if (page > 0 && perPage > 0) {
            sqlBuilder.append(" LIMIT ").append((page - 1) * perPage).append(",").append(perPage);
        } else {
            sqlBuilder.append(" LIMIT ").append(10);
        }
        return sqlBuilder.toString();
    }

    public JobEventRdbSearch(DataSource dataSource, boolean enable) {
        this.dataSource = dataSource;
        this.enable = enable;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public static class Condition {
        private static final int DEFAULT_PAGE_SIZE = 10;
        private final int perPage;
        private final int page;
        private final String sort;
        private final String order;
        private final Date startTime;
        private final Date endTime;
        private final Map<String, Object> fields;

        public Condition(int perPage, int page, String sort, String order, Date startTime, Date endTime, Map<String, Object> fields) {
            this.perPage = perPage;
            this.page = page;
            this.sort = sort;
            this.order = order;
            this.startTime = startTime;
            this.endTime = endTime;
            this.fields = fields;
        }

        public int getPerPage() {
            return this.perPage;
        }

        public int getPage() {
            return this.page;
        }

        public String getSort() {
            return this.sort;
        }

        public String getOrder() {
            return this.order;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public Map<String, Object> getFields() {
            return this.fields;
        }
    }

    public static class Result<T> {
        private final Integer total;
        private final List<T> rows;

        public Result(Integer total, List<T> rows) {
            this.total = total;
            this.rows = rows;
        }

        public Integer getTotal() {
            return this.total;
        }

        public List<T> getRows() {
            return this.rows;
        }
    }
}

