/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionSelect;
import org.aspectj.apache.bcel.util.ByteSequence;

public class TABLESWITCH
extends InstructionSelect {
    public TABLESWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super((short)170, nArray, instructionHandleArray, instructionHandle);
        this.length = (short)(13 + this.matchLength * 4);
        this.fixedLength = this.length;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        int n = this.matchLength > 0 ? this.match[0] : 0;
        dataOutputStream.writeInt(n);
        int n2 = this.matchLength > 0 ? this.match[this.matchLength - 1] : 0;
        dataOutputStream.writeInt(n2);
        for (int i = 0; i < this.matchLength; ++i) {
            this.indices[i] = this.getTargetOffset(this.targets[i]);
            dataOutputStream.writeInt(this.indices[i]);
        }
    }

    public TABLESWITCH(ByteSequence byteSequence) throws IOException {
        super((short)170, byteSequence);
        int n;
        int n2 = byteSequence.readInt();
        int n3 = byteSequence.readInt();
        this.matchLength = n3 - n2 + 1;
        this.fixedLength = (short)(13 + this.matchLength * 4);
        this.length = (short)(this.fixedLength + this.padding);
        this.match = new int[this.matchLength];
        this.indices = new int[this.matchLength];
        this.targets = new InstructionHandle[this.matchLength];
        for (n = n2; n <= n3; ++n) {
            this.match[n - n2] = n;
        }
        for (n = 0; n < this.matchLength; ++n) {
            this.indices[n] = byteSequence.readInt();
        }
    }
}

