/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Exp;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;
import org.apache.openjpa.kernel.exps.WhenCondition;
import org.apache.openjpa.lib.util.Localizer;

class GeneralCase
extends Val {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(GeneralCase.class);
    private final Exp[] _exp;
    private final Val _val;

    public GeneralCase(Exp[] exp, Val val) {
        this._exp = exp;
        this._val = val;
    }

    @Override
    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        for (int i = 0; i < this._exp.length; ++i) {
            boolean compare = ((WhenCondition)this._exp[i]).getExp().eval(candidate, orig, ctx, params);
            if (!compare) continue;
            return ((WhenCondition)this._exp[i]).getVal().eval(candidate, orig, ctx, params);
        }
        return this._val.eval(candidate, orig, ctx, params);
    }

    protected Object eval(Object candidate, StoreContext ctx, Object[] params) {
        for (int i = 0; i < this._exp.length; ++i) {
            boolean compare = ((WhenCondition)this._exp[i]).getExp().eval(candidate, null, ctx, params);
            if (!compare) continue;
            return ((WhenCondition)this._exp[i]).getVal().eval(candidate, null, ctx, params);
        }
        return this._val.eval(candidate, null, ctx, params);
    }

    @Override
    public Class getType() {
        Class<?> c1 = this._val.getType();
        for (int i = 0; i < this._exp.length; ++i) {
            Class c2 = ((WhenCondition)this._exp[i]).getVal().getType();
            c1 = Filters.promote(c1, c2);
        }
        return c1;
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        for (int i = 0; i < this._exp.length; ++i) {
            this._exp[i].acceptVisit(visitor);
        }
        this._val.acceptVisit(visitor);
        visitor.exit(this);
    }
}

