/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.FieldOrMethod;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.Type;

public final class Field
extends FieldOrMethod {
    public static final Field[] NoFields = new Field[0];
    private Type fieldType = null;

    private Field() {
    }

    public Field(Field field) {
        super(field);
    }

    Field(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        super(dataInputStream, constantPool);
    }

    public Field(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n, n2, n3, attributeArray, constantPool);
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        return AttributeUtils.getConstantValueAttribute(this.attributes);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(Utility.accessToString(this.modifiers));
        if (stringBuffer.length() > 0) {
            stringBuffer.append(" ");
        }
        String string = Utility.signatureToString(this.getSignature());
        stringBuffer.append(string).append(" ").append(this.getName());
        ConstantValue constantValue = this.getConstantValue();
        if (constantValue != null) {
            stringBuffer.append(" = ").append(constantValue);
        }
        for (Attribute attribute : this.attributes) {
            if (attribute instanceof ConstantValue) continue;
            stringBuffer.append(" [").append(attribute.toString()).append("]");
        }
        return stringBuffer.toString();
    }

    public Type getType() {
        if (this.fieldType == null) {
            this.fieldType = Type.getReturnType(this.getSignature());
        }
        return this.fieldType;
    }
}

