/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.handler.sharding;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobShardingStrategy;

public final class JobShardingStrategyFactory {
    private static final Map<String, JobShardingStrategy> STRATEGIES = new LinkedHashMap<String, JobShardingStrategy>();
    private static final String DEFAULT_STRATEGY = "AVG_ALLOCATION";

    public static JobShardingStrategy getStrategy(String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            return STRATEGIES.get(DEFAULT_STRATEGY);
        }
        if (!STRATEGIES.containsKey(type)) {
            throw new JobConfigurationException("Can not find sharding sharding type '%s'.", type);
        }
        return STRATEGIES.get(type);
    }

    @Generated
    private JobShardingStrategyFactory() {
    }

    static {
        for (JobShardingStrategy each : ServiceLoader.load(JobShardingStrategy.class)) {
            STRATEGIES.put(each.getType(), each);
        }
    }
}

