/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Properties;
import lombok.Generated;

public final class JobConfiguration {
    private final String jobName;
    private final String cron;
    private final int shardingTotalCount;
    private final String shardingItemParameters;
    private final String jobParameter;
    private final boolean monitorExecution;
    private final boolean failover;
    private final boolean misfire;
    private final int maxTimeDiffSeconds;
    private final int reconcileIntervalMinutes;
    private final String jobShardingStrategyType;
    private final String jobExecutorServiceHandlerType;
    private final String jobErrorHandlerType;
    private final String description;
    private final Properties props;
    private final boolean disabled;
    private final boolean overwrite;

    public static Builder newBuilder(String jobName, int shardingTotalCount) {
        return new Builder(jobName, shardingTotalCount);
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public String getCron() {
        return this.cron;
    }

    @Generated
    public int getShardingTotalCount() {
        return this.shardingTotalCount;
    }

    @Generated
    public String getShardingItemParameters() {
        return this.shardingItemParameters;
    }

    @Generated
    public String getJobParameter() {
        return this.jobParameter;
    }

    @Generated
    public boolean isMonitorExecution() {
        return this.monitorExecution;
    }

    @Generated
    public boolean isFailover() {
        return this.failover;
    }

    @Generated
    public boolean isMisfire() {
        return this.misfire;
    }

    @Generated
    public int getMaxTimeDiffSeconds() {
        return this.maxTimeDiffSeconds;
    }

    @Generated
    public int getReconcileIntervalMinutes() {
        return this.reconcileIntervalMinutes;
    }

    @Generated
    public String getJobShardingStrategyType() {
        return this.jobShardingStrategyType;
    }

    @Generated
    public String getJobExecutorServiceHandlerType() {
        return this.jobExecutorServiceHandlerType;
    }

    @Generated
    public String getJobErrorHandlerType() {
        return this.jobErrorHandlerType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Generated
    private JobConfiguration(String jobName, String cron, int shardingTotalCount, String shardingItemParameters, String jobParameter, boolean monitorExecution, boolean failover, boolean misfire, int maxTimeDiffSeconds, int reconcileIntervalMinutes, String jobShardingStrategyType, String jobExecutorServiceHandlerType, String jobErrorHandlerType, String description, Properties props, boolean disabled, boolean overwrite) {
        this.jobName = jobName;
        this.cron = cron;
        this.shardingTotalCount = shardingTotalCount;
        this.shardingItemParameters = shardingItemParameters;
        this.jobParameter = jobParameter;
        this.monitorExecution = monitorExecution;
        this.failover = failover;
        this.misfire = misfire;
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
        this.reconcileIntervalMinutes = reconcileIntervalMinutes;
        this.jobShardingStrategyType = jobShardingStrategyType;
        this.jobExecutorServiceHandlerType = jobExecutorServiceHandlerType;
        this.jobErrorHandlerType = jobErrorHandlerType;
        this.description = description;
        this.props = props;
        this.disabled = disabled;
        this.overwrite = overwrite;
    }

    public static class Builder {
        private final String jobName;
        private String cron;
        private final int shardingTotalCount;
        private String shardingItemParameters = "";
        private String jobParameter = "";
        private boolean monitorExecution = true;
        private boolean failover;
        private boolean misfire = true;
        private int maxTimeDiffSeconds = -1;
        private int reconcileIntervalMinutes = 10;
        private String jobShardingStrategyType;
        private String jobExecutorServiceHandlerType;
        private String jobErrorHandlerType;
        private String description = "";
        private final Properties props = new Properties();
        private boolean disabled;
        private boolean overwrite;

        public Builder cron(String cron) {
            if (null != cron) {
                this.cron = cron;
            }
            return this;
        }

        public Builder shardingItemParameters(String shardingItemParameters) {
            if (null != shardingItemParameters) {
                this.shardingItemParameters = shardingItemParameters;
            }
            return this;
        }

        public Builder jobParameter(String jobParameter) {
            if (null != jobParameter) {
                this.jobParameter = jobParameter;
            }
            return this;
        }

        public Builder monitorExecution(boolean monitorExecution) {
            this.monitorExecution = monitorExecution;
            return this;
        }

        public Builder failover(boolean failover) {
            this.failover = failover;
            return this;
        }

        public Builder misfire(boolean misfire) {
            this.misfire = misfire;
            return this;
        }

        public Builder maxTimeDiffSeconds(int maxTimeDiffSeconds) {
            this.maxTimeDiffSeconds = maxTimeDiffSeconds;
            return this;
        }

        public Builder reconcileIntervalMinutes(int reconcileIntervalMinutes) {
            this.reconcileIntervalMinutes = reconcileIntervalMinutes;
            return this;
        }

        public Builder jobShardingStrategyType(String jobShardingStrategyType) {
            if (null != jobShardingStrategyType) {
                this.jobShardingStrategyType = jobShardingStrategyType;
            }
            return this;
        }

        public Builder jobExecutorServiceHandlerType(String jobExecutorServiceHandlerType) {
            this.jobExecutorServiceHandlerType = jobExecutorServiceHandlerType;
            return this;
        }

        public Builder jobErrorHandlerType(String jobErrorHandlerType) {
            this.jobErrorHandlerType = jobErrorHandlerType;
            return this;
        }

        public Builder description(String description) {
            if (null != description) {
                this.description = description;
            }
            return this;
        }

        public Builder setProperty(String key, String value) {
            this.props.setProperty(key, value);
            return this;
        }

        public Builder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder overwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public final JobConfiguration build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.jobName) ? 1 : 0) != 0, (Object)"jobName can not be empty.");
            Preconditions.checkArgument((this.shardingTotalCount > 0 ? 1 : 0) != 0, (Object)"shardingTotalCount should larger than zero.");
            return new JobConfiguration(this.jobName, this.cron, this.shardingTotalCount, this.shardingItemParameters, this.jobParameter, this.monitorExecution, this.failover, this.misfire, this.maxTimeDiffSeconds, this.reconcileIntervalMinutes, this.jobShardingStrategyType, this.jobExecutorServiceHandlerType, this.jobErrorHandlerType, this.description, this.props, this.disabled, this.overwrite);
        }

        @Generated
        private Builder(String jobName, int shardingTotalCount) {
            this.jobName = jobName;
            this.shardingTotalCount = shardingTotalCount;
        }
    }
}

