/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.service.impl;

import java.util.Optional;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.GlobalConfiguration;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.RegistryCenterConfiguration;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.RegistryCenterConfigurations;
import org.apache.shardingsphere.elasticjob.lite.ui.repository.ConfigurationsXmlRepository;
import org.apache.shardingsphere.elasticjob.lite.ui.repository.impl.ConfigurationsXmlRepositoryImpl;
import org.apache.shardingsphere.elasticjob.lite.ui.service.RegistryCenterConfigurationService;
import org.springframework.stereotype.Service;

@Service
public final class RegistryCenterConfigurationServiceImpl
implements RegistryCenterConfigurationService {
    private ConfigurationsXmlRepository configurationsXmlRepository = new ConfigurationsXmlRepositoryImpl();

    @Override
    public RegistryCenterConfigurations loadAll() {
        return this.loadGlobal().getRegistryCenterConfigurations();
    }

    @Override
    public RegistryCenterConfiguration load(String name) {
        GlobalConfiguration configs = this.loadGlobal();
        RegistryCenterConfiguration result = this.find(name, configs.getRegistryCenterConfigurations());
        this.setActivated(configs, result);
        return result;
    }

    @Override
    public RegistryCenterConfiguration find(String name, RegistryCenterConfigurations configs) {
        for (RegistryCenterConfiguration each : configs.getRegistryCenterConfiguration()) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    private void setActivated(GlobalConfiguration configs, RegistryCenterConfiguration toBeConnectedConfig) {
        RegistryCenterConfiguration activatedConfig = this.findActivatedRegistryCenterConfiguration(configs);
        if (!toBeConnectedConfig.equals(activatedConfig)) {
            if (null != activatedConfig) {
                activatedConfig.setActivated(false);
            }
            toBeConnectedConfig.setActivated(true);
            this.configurationsXmlRepository.save(configs);
        }
    }

    @Override
    public Optional<RegistryCenterConfiguration> loadActivated() {
        return Optional.ofNullable(this.findActivatedRegistryCenterConfiguration(this.loadGlobal()));
    }

    private RegistryCenterConfiguration findActivatedRegistryCenterConfiguration(GlobalConfiguration configs) {
        for (RegistryCenterConfiguration each : configs.getRegistryCenterConfigurations().getRegistryCenterConfiguration()) {
            if (!each.isActivated()) continue;
            return each;
        }
        return null;
    }

    @Override
    public boolean add(RegistryCenterConfiguration config) {
        GlobalConfiguration configs = this.loadGlobal();
        boolean result = configs.getRegistryCenterConfigurations().getRegistryCenterConfiguration().add(config);
        if (result) {
            this.configurationsXmlRepository.save(configs);
        }
        return result;
    }

    @Override
    public void delete(String name) {
        GlobalConfiguration configs = this.loadGlobal();
        RegistryCenterConfiguration toBeRemovedConfig = this.find(name, configs.getRegistryCenterConfigurations());
        if (null != toBeRemovedConfig) {
            configs.getRegistryCenterConfigurations().getRegistryCenterConfiguration().remove(toBeRemovedConfig);
            this.configurationsXmlRepository.save(configs);
        }
    }

    private GlobalConfiguration loadGlobal() {
        GlobalConfiguration result = (GlobalConfiguration)this.configurationsXmlRepository.load();
        if (null == result.getRegistryCenterConfigurations()) {
            result.setRegistryCenterConfigurations(new RegistryCenterConfigurations());
        }
        return result;
    }
}

