/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.service.impl;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.shardingsphere.elasticjob.lite.ui.dao.search.JobExecutionLogRepository;
import org.apache.shardingsphere.elasticjob.lite.ui.dao.search.JobStatusTraceLogRepository;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.JobExecutionLog;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.JobStatusTraceLog;
import org.apache.shardingsphere.elasticjob.lite.ui.dto.request.BasePageRequest;
import org.apache.shardingsphere.elasticjob.lite.ui.dto.request.FindJobExecutionEventsRequest;
import org.apache.shardingsphere.elasticjob.lite.ui.dto.request.FindJobStatusTraceEventsRequest;
import org.apache.shardingsphere.elasticjob.lite.ui.service.EventTraceHistoryService;
import org.apache.shardingsphere.elasticjob.lite.ui.util.BeanUtils;
import org.apache.shardingsphere.elasticjob.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.convert.QueryByExamplePredicateBuilder;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public final class EventTraceHistoryServiceImpl
implements EventTraceHistoryService {
    private static final Logger log = LoggerFactory.getLogger(EventTraceHistoryServiceImpl.class);
    @Autowired
    private JobExecutionLogRepository jobExecutionLogRepository;
    @Autowired
    private JobStatusTraceLogRepository jobStatusTraceLogRepository;

    @Override
    public Page<JobExecutionEvent> findJobExecutionEvents(FindJobExecutionEventsRequest findJobExecutionEventsRequest) {
        Example<JobExecutionLog> jobExecutionLogExample = this.getExample(findJobExecutionEventsRequest, JobExecutionLog.class);
        Specification<JobExecutionLog> specification = this.getSpecWithExampleAndDate(jobExecutionLogExample, findJobExecutionEventsRequest.getStart(), findJobExecutionEventsRequest.getEnd(), "startTime");
        Page page = this.jobExecutionLogRepository.findAll(specification, this.getPageable(findJobExecutionEventsRequest, JobExecutionLog.class));
        return new PageImpl(page.getContent().stream().map(JobExecutionLog::toJobExecutionEvent).collect(Collectors.toList()), null, page.getTotalElements());
    }

    @Override
    public List<String> findJobNamesInExecutionLog(String jobNamePrefix) {
        return this.jobExecutionLogRepository.findJobNameByJobNameLike(jobNamePrefix);
    }

    @Override
    public List<String> findIpInExecutionLog(String ipPrefix) {
        return this.jobExecutionLogRepository.findIpByIpLike(ipPrefix);
    }

    @Override
    public Page<JobStatusTraceEvent> findJobStatusTraceEvents(FindJobStatusTraceEventsRequest findJobStatusTraceEventsRequest) {
        Example<JobStatusTraceLog> jobStatusTraceLogExample = this.getExample(findJobStatusTraceEventsRequest, JobStatusTraceLog.class);
        Specification<JobStatusTraceLog> specification = this.getSpecWithExampleAndDate(jobStatusTraceLogExample, findJobStatusTraceEventsRequest.getStart(), findJobStatusTraceEventsRequest.getEnd(), "creationTime");
        Page page = this.jobStatusTraceLogRepository.findAll(specification, this.getPageable(findJobStatusTraceEventsRequest, JobStatusTraceLog.class));
        return new PageImpl(page.getContent().stream().map(JobStatusTraceLog::toJobStatusTraceEvent).collect(Collectors.toList()), null, page.getTotalElements());
    }

    @Override
    public List<String> findJobNamesInStatusTraceLog(String jobNamePrefix) {
        return this.jobStatusTraceLogRepository.findJobNameByJobNameLike(jobNamePrefix);
    }

    private <T> Pageable getPageable(BasePageRequest pageRequest, Class<T> clazz) {
        int page = 0;
        int perPage = 10;
        if (pageRequest.getPageNumber() > 0 && pageRequest.getPageSize() > 0) {
            page = pageRequest.getPageNumber() - 1;
            perPage = pageRequest.getPageSize();
        }
        return new PageRequest(page, perPage, this.getSort(pageRequest, clazz));
    }

    private <T> Sort getSort(BasePageRequest pageRequest, Class<T> clazz) {
        Sort sort = null;
        boolean sortFieldIsPresent = Arrays.stream(clazz.getDeclaredFields()).map(Field::getName).anyMatch(e -> e.equals(pageRequest.getSortBy()));
        if (!sortFieldIsPresent) {
            return sort;
        }
        if (!Strings.isNullOrEmpty((String)pageRequest.getSortBy())) {
            Sort.Direction order = Sort.Direction.ASC;
            try {
                order = Sort.Direction.valueOf((String)pageRequest.getOrderType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            sort = new Sort(order, new String[]{pageRequest.getSortBy()});
        }
        return sort;
    }

    private <T> Specification<T> getSpecWithExampleAndDate(Example<T> example, Date from, Date to, String field) {
        return (root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (from != null) {
                predicates.add(builder.greaterThan((Expression)root.get(field), (Comparable)from));
            }
            if (to != null) {
                predicates.add(builder.lessThan((Expression)root.get(field), (Comparable)to));
            }
            predicates.add(QueryByExamplePredicateBuilder.getPredicate((Root)root, (CriteriaBuilder)builder, (Example)example));
            return builder.and(predicates.toArray(new Predicate[0]));
        };
    }

    private <T> Example<T> getExample(Object source, Class<T> clazz) {
        T instance = BeanUtils.newInstance(clazz);
        BeanUtils.copyProperties((Object)source, instance);
        return Example.of(instance);
    }
}

