/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.TypeAnnotationGen;

public abstract class RuntimeTypeAnnos
extends Attribute {
    private boolean visible;
    private TypeAnnotationGen[] typeAnnotations;
    private byte[] annotation_data;

    public RuntimeTypeAnnos(byte by, boolean bl, int n, int n2, ConstantPool constantPool) {
        super(by, n, n2, constantPool);
        this.visible = bl;
    }

    protected void readTypeAnnotations(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.annotation_data = new byte[this.length];
        dataInputStream.readFully(this.annotation_data, 0, this.length);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        this.writeTypeAnnotations(dataOutputStream);
    }

    protected void writeTypeAnnotations(DataOutputStream dataOutputStream) throws IOException {
        if (this.typeAnnotations == null) {
            dataOutputStream.write(this.annotation_data, 0, this.length);
        } else {
            dataOutputStream.writeShort(this.typeAnnotations.length);
            for (int i = 0; i < this.typeAnnotations.length; ++i) {
                this.typeAnnotations[i].dump(dataOutputStream);
            }
        }
    }

    public Attribute copy(ConstantPool constantPool) {
        throw new RuntimeException("Not implemented yet!");
    }

    public TypeAnnotationGen[] getTypeAnnotations() {
        this.ensureInflated();
        return this.typeAnnotations;
    }

    public boolean areVisible() {
        return this.visible;
    }

    private void ensureInflated() {
        if (this.typeAnnotations != null) {
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.annotation_data));
            int n = dataInputStream.readUnsignedShort();
            if (n == 0) {
                this.typeAnnotations = TypeAnnotationGen.NO_TYPE_ANNOTATIONS;
            } else {
                this.typeAnnotations = new TypeAnnotationGen[n];
                for (int i = 0; i < n; ++i) {
                    this.typeAnnotations[i] = TypeAnnotationGen.read(dataInputStream, this.getConstantPool(), this.visible);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unabled to inflate type annotation data, badly formed?");
        }
    }

    @Override
    public String toString() {
        return "Runtime" + (this.visible ? "Visible" : "Invisible") + "TypeAnnotations [" + (this.isInflated() ? "inflated" : "not yet inflated") + "]";
    }

    public boolean isInflated() {
        return this.typeAnnotations != null;
    }
}

