/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.sharding;

import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationNode;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceNode;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerNode;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ShardingListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final ConfigurationNode configNode;
    private final InstanceNode instanceNode;
    private final ServerNode serverNode;
    private final ShardingService shardingService;

    public ShardingListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.configNode = new ConfigurationNode(jobName);
        this.instanceNode = new InstanceNode(jobName);
        this.serverNode = new ServerNode(jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new ShardingTotalCountChangedJobListener());
        this.addDataListener(new ListenServersChangedJobListener());
    }

    class ListenServersChangedJobListener
    extends AbstractJobListener {
        ListenServersChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (!JobRegistry.getInstance().isShutdown(ShardingListenerManager.this.jobName) && (this.isInstanceChange(eventType, path) || this.isServerChange(path))) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
            }
        }

        private boolean isInstanceChange(CuratorCacheListener.Type eventType, String path) {
            return ShardingListenerManager.this.instanceNode.isInstancePath(path) && CuratorCacheListener.Type.NODE_CHANGED != eventType;
        }

        private boolean isServerChange(String path) {
            return ShardingListenerManager.this.serverNode.isServerPath(path);
        }
    }

    class ShardingTotalCountChangedJobListener
    extends AbstractJobListener {
        ShardingTotalCountChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            int newShardingTotalCount;
            if (ShardingListenerManager.this.configNode.isConfigPath(path) && 0 != JobRegistry.getInstance().getCurrentShardingTotalCount(ShardingListenerManager.this.jobName) && (newShardingTotalCount = ((JobConfigurationPOJO)YamlEngine.unmarshal((String)data, JobConfigurationPOJO.class)).toJobConfiguration().getShardingTotalCount()) != JobRegistry.getInstance().getCurrentShardingTotalCount(ShardingListenerManager.this.jobName)) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
                JobRegistry.getInstance().setCurrentShardingTotalCount(ShardingListenerManager.this.jobName, newShardingTotalCount);
            }
        }
    }
}

