/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.schedule;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.api.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.api.listener.ShardingContexts;
import org.apache.shardingsphere.elasticjob.executor.JobFacade;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.infra.exception.JobExecutionEnvironmentException;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.failover.FailoverService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ExecutionContextService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.tracing.JobEventBus;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.tracing.event.JobEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LiteJobFacade
implements JobFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteJobFacade.class);
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final ExecutionContextService executionContextService;
    private final ExecutionService executionService;
    private final FailoverService failoverService;
    private final List<ElasticJobListener> elasticJobListeners;
    private final JobEventBus jobEventBus;

    public LiteJobFacade(CoordinatorRegistryCenter regCenter, String jobName, List<ElasticJobListener> elasticJobListeners, TracingConfiguration tracingConfig) {
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionContextService = new ExecutionContextService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.elasticJobListeners = elasticJobListeners;
        this.jobEventBus = null == tracingConfig ? new JobEventBus() : new JobEventBus(tracingConfig);
    }

    public JobConfiguration loadJobConfiguration(boolean fromCache) {
        return this.configService.load(fromCache);
    }

    public void checkJobExecutionEnvironment() throws JobExecutionEnvironmentException {
        this.configService.checkMaxTimeDiffSecondsTolerable();
    }

    public void failoverIfNecessary() {
        if (this.configService.load(true).isFailover()) {
            this.failoverService.failoverIfNecessary();
        }
    }

    public void registerJobBegin(ShardingContexts shardingContexts) {
        this.executionService.registerJobBegin(shardingContexts);
    }

    public void registerJobCompleted(ShardingContexts shardingContexts) {
        this.executionService.registerJobCompleted(shardingContexts);
        if (this.configService.load(true).isFailover()) {
            this.failoverService.updateFailoverComplete(shardingContexts.getShardingItemParameters().keySet());
        }
    }

    public ShardingContexts getShardingContexts() {
        List<Integer> failoverShardingItems;
        boolean isFailover = this.configService.load(true).isFailover();
        if (isFailover && !(failoverShardingItems = this.failoverService.getLocalFailoverItems()).isEmpty()) {
            return this.executionContextService.getJobShardingContext(failoverShardingItems);
        }
        this.shardingService.shardingIfNecessary();
        List<Integer> shardingItems = this.shardingService.getLocalShardingItems();
        if (isFailover) {
            shardingItems.removeAll(this.failoverService.getLocalTakeOffItems());
        }
        shardingItems.removeAll(this.executionService.getDisabledItems(shardingItems));
        return this.executionContextService.getJobShardingContext(shardingItems);
    }

    public boolean misfireIfRunning(Collection<Integer> shardingItems) {
        return this.executionService.misfireIfHasRunningItems(shardingItems);
    }

    public void clearMisfire(Collection<Integer> shardingItems) {
        this.executionService.clearMisfire(shardingItems);
    }

    public boolean isExecuteMisfired(Collection<Integer> shardingItems) {
        return !this.isNeedSharding() && this.configService.load(true).isMisfire() && !this.executionService.getMisfiredJobItems(shardingItems).isEmpty();
    }

    public boolean isNeedSharding() {
        return this.shardingService.isNeedSharding();
    }

    public void beforeJobExecuted(ShardingContexts shardingContexts) {
        for (ElasticJobListener each : this.elasticJobListeners) {
            each.beforeJobExecuted(shardingContexts);
        }
    }

    public void afterJobExecuted(ShardingContexts shardingContexts) {
        for (ElasticJobListener each : this.elasticJobListeners) {
            each.afterJobExecuted(shardingContexts);
        }
    }

    public void postJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        this.jobEventBus.post((JobEvent)jobExecutionEvent);
    }

    public void postJobStatusTraceEvent(String taskId, JobStatusTraceEvent.State state, String message) {
        TaskContext taskContext = TaskContext.from((String)taskId);
        this.jobEventBus.post((JobEvent)new JobStatusTraceEvent(taskContext.getMetaInfo().getJobName(), taskContext.getId(), taskContext.getSlaveId(), JobStatusTraceEvent.Source.LITE_EXECUTOR, taskContext.getType().name(), taskContext.getMetaInfo().getShardingItems().toString(), state, message));
        if (!Strings.isNullOrEmpty((String)message)) {
            log.trace(message);
        }
    }
}

