/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.web.controller;

import org.apache.shardingsphere.elasticjob.lite.ui.dto.request.FindJobExecutionEventsRequest;
import org.apache.shardingsphere.elasticjob.lite.ui.dto.request.FindJobStatusTraceEventsRequest;
import org.apache.shardingsphere.elasticjob.lite.ui.dto.response.BasePageResponse;
import org.apache.shardingsphere.elasticjob.lite.ui.service.EventTraceDataSourceConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.ui.service.EventTraceHistoryService;
import org.apache.shardingsphere.elasticjob.lite.ui.util.SessionEventTraceDataSourceConfiguration;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResult;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResultUtil;
import org.apache.shardingsphere.elasticjob.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/event-trace"})
public final class EventTraceHistoryController {
    @Autowired
    private EventTraceHistoryService eventTraceHistoryService;
    @Autowired
    private EventTraceDataSourceConfigurationService eventTraceDataSourceConfigurationService;

    @PostMapping(value={"/execution"})
    public ResponseResult<BasePageResponse<JobExecutionEvent>> findJobExecutionEvents(@RequestBody FindJobExecutionEventsRequest requestParams) {
        Page<JobExecutionEvent> jobExecutionEvents = this.eventTraceHistoryService.findJobExecutionEvents(requestParams);
        return ResponseResultUtil.build(BasePageResponse.of(jobExecutionEvents));
    }

    @PostMapping(value={"/status"})
    public ResponseResult<BasePageResponse<JobStatusTraceEvent>> findJobStatusTraceEvents(@RequestBody FindJobStatusTraceEventsRequest requestParams) {
        Page<JobStatusTraceEvent> jobStatusTraceEvents = this.eventTraceHistoryService.findJobStatusTraceEvents(requestParams);
        return ResponseResultUtil.build(BasePageResponse.of(jobStatusTraceEvents));
    }

    @ModelAttribute
    private void initDataSource() {
        this.eventTraceDataSourceConfigurationService.loadActivated().ifPresent(config -> SessionEventTraceDataSourceConfiguration.setDataSourceConfiguration(config));
    }
}

