/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.service.impl;

import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.elasticjob.lite.ui.config.DynamicDataSourceConfig;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.DataSourceFactory;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.EventTraceDataSourceConfiguration;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.EventTraceDataSourceConfigurations;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.GlobalConfiguration;
import org.apache.shardingsphere.elasticjob.lite.ui.repository.ConfigurationsXmlRepository;
import org.apache.shardingsphere.elasticjob.lite.ui.repository.impl.ConfigurationsXmlRepositoryImpl;
import org.apache.shardingsphere.elasticjob.lite.ui.service.EventTraceDataSourceConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class EventTraceDataSourceConfigurationServiceImpl
implements EventTraceDataSourceConfigurationService,
InitializingBean {
    private ConfigurationsXmlRepository configurationsXmlRepository = new ConfigurationsXmlRepositoryImpl();
    @Autowired
    private DynamicDataSourceConfig.DynamicDataSource dynamicDataSource;

    @Override
    public EventTraceDataSourceConfigurations loadAll() {
        return this.loadGlobal().getEventTraceDataSourceConfigurations();
    }

    @Override
    public EventTraceDataSourceConfiguration load(String name) {
        GlobalConfiguration configs = this.loadGlobal();
        EventTraceDataSourceConfiguration result = this.find(name, configs.getEventTraceDataSourceConfigurations());
        this.setActivated(configs, result);
        DynamicDataSourceConfig.DynamicDataSourceContextHolder.setDataSourceName(name);
        return result;
    }

    @Override
    public EventTraceDataSourceConfiguration find(String name, EventTraceDataSourceConfigurations configs) {
        for (EventTraceDataSourceConfiguration each : configs.getEventTraceDataSourceConfiguration()) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    private void setActivated(GlobalConfiguration configs, EventTraceDataSourceConfiguration toBeConnectedConfig) {
        EventTraceDataSourceConfiguration activatedConfig = this.findActivatedDataSourceConfiguration(configs);
        if (!toBeConnectedConfig.equals(activatedConfig)) {
            if (null != activatedConfig) {
                activatedConfig.setActivated(false);
            }
            toBeConnectedConfig.setActivated(true);
            this.configurationsXmlRepository.save(configs);
        }
    }

    @Override
    public Optional<EventTraceDataSourceConfiguration> loadActivated() {
        return Optional.ofNullable(this.findActivatedDataSourceConfiguration(this.loadGlobal()));
    }

    private EventTraceDataSourceConfiguration findActivatedDataSourceConfiguration(GlobalConfiguration configs) {
        for (EventTraceDataSourceConfiguration each : configs.getEventTraceDataSourceConfigurations().getEventTraceDataSourceConfiguration()) {
            if (!each.isActivated()) continue;
            return each;
        }
        return null;
    }

    @Override
    public boolean add(EventTraceDataSourceConfiguration config) {
        GlobalConfiguration configs = this.loadGlobal();
        boolean result = configs.getEventTraceDataSourceConfigurations().getEventTraceDataSourceConfiguration().add(config);
        if (result) {
            this.configurationsXmlRepository.save(configs);
        }
        DataSource dataSource = DataSourceFactory.createDataSource(config);
        this.dynamicDataSource.addDataSource(config.getName(), dataSource);
        return result;
    }

    @Override
    public void delete(String name) {
        GlobalConfiguration configs = this.loadGlobal();
        EventTraceDataSourceConfiguration toBeRemovedConfig = this.find(name, configs.getEventTraceDataSourceConfigurations());
        if (null != toBeRemovedConfig) {
            configs.getEventTraceDataSourceConfigurations().getEventTraceDataSourceConfiguration().remove(toBeRemovedConfig);
            this.configurationsXmlRepository.save(configs);
        }
    }

    private GlobalConfiguration loadGlobal() {
        GlobalConfiguration result = (GlobalConfiguration)this.configurationsXmlRepository.load();
        if (null == result.getEventTraceDataSourceConfigurations()) {
            result.setEventTraceDataSourceConfigurations(new EventTraceDataSourceConfigurations());
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        this.loadGlobal().getEventTraceDataSourceConfigurations().getEventTraceDataSourceConfiguration().stream().forEach(each -> this.afterLoad((EventTraceDataSourceConfiguration)each));
    }

    private void afterLoad(EventTraceDataSourceConfiguration config) {
        if (config.isActivated()) {
            DataSource dataSource = DataSourceFactory.createDataSource(config);
            this.dynamicDataSource.addDataSource(config.getName(), dataSource);
            DynamicDataSourceConfig.DynamicDataSourceContextHolder.setDataSourceName(config.getName());
        }
    }
}

