/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.domain;

import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.EventTraceDataSourceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventTraceDataSource {
    private static final Logger log = LoggerFactory.getLogger(EventTraceDataSource.class);
    private final EventTraceDataSourceConfiguration eventTraceDataSourceConfiguration;

    public void init() {
        log.debug("ElasticJob: data source init, connection url is: {}.", (Object)this.eventTraceDataSourceConfiguration.getUrl());
        try {
            Class.forName(this.eventTraceDataSourceConfiguration.getDriver());
            DriverManager.getConnection(this.eventTraceDataSourceConfiguration.getUrl(), this.eventTraceDataSourceConfiguration.getUsername(), this.eventTraceDataSourceConfiguration.getPassword());
        }
        catch (ClassNotFoundException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public EventTraceDataSource(EventTraceDataSourceConfiguration eventTraceDataSourceConfiguration) {
        this.eventTraceDataSourceConfiguration = eventTraceDataSourceConfiguration;
    }

    protected EventTraceDataSourceConfiguration getEventTraceDataSourceConfiguration() {
        return this.eventTraceDataSourceConfiguration;
    }
}

