/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.SourceFile;

public class AttributeUtils {
    public static Attribute[] readAttributes(DataInputStream dataInputStream, ConstantPool constantPool) {
        try {
            int n = dataInputStream.readUnsignedShort();
            if (n == 0) {
                return Attribute.NoAttributes;
            }
            Attribute[] attributeArray = new Attribute[n];
            for (int i = 0; i < n; ++i) {
                attributeArray[i] = Attribute.readAttribute(dataInputStream, constantPool);
            }
            return attributeArray;
        }
        catch (IOException iOException) {
            throw new ClassFormatException("IOException whilst reading set of attributes: " + iOException.toString());
        }
    }

    public static void writeAttributes(Attribute[] attributeArray, DataOutputStream dataOutputStream) throws IOException {
        if (attributeArray == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(attributeArray.length);
            for (int i = 0; i < attributeArray.length; ++i) {
                attributeArray[i].dump(dataOutputStream);
            }
        }
    }

    public static Signature getSignatureAttribute(Attribute[] attributeArray) {
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].tag != 10) continue;
            return (Signature)attributeArray[i];
        }
        return null;
    }

    public static Code getCodeAttribute(Attribute[] attributeArray) {
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].tag != 2) continue;
            return (Code)attributeArray[i];
        }
        return null;
    }

    public static ExceptionTable getExceptionTableAttribute(Attribute[] attributeArray) {
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].tag != 3) continue;
            return (ExceptionTable)attributeArray[i];
        }
        return null;
    }

    public static ConstantValue getConstantValueAttribute(Attribute[] attributeArray) {
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getTag() != 1) continue;
            return (ConstantValue)attributeArray[i];
        }
        return null;
    }

    public static void accept(Attribute[] attributeArray, ClassVisitor classVisitor) {
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i].accept(classVisitor);
        }
    }

    public static boolean hasSyntheticAttribute(Attribute[] attributeArray) {
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].tag != 7) continue;
            return true;
        }
        return false;
    }

    public static SourceFile getSourceFileAttribute(Attribute[] attributeArray) {
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].tag != 0) continue;
            return (SourceFile)attributeArray[i];
        }
        return null;
    }
}

