/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.handler.error;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.infra.handler.error.JobErrorHandler;

public final class JobErrorHandlerFactory {
    private static final Map<String, JobErrorHandler> HANDLERS = new LinkedHashMap<String, JobErrorHandler>();
    private static final String DEFAULT_HANDLER = "LOG";

    public static JobErrorHandler getHandler(String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            return HANDLERS.get(DEFAULT_HANDLER);
        }
        if (!HANDLERS.containsKey(type)) {
            throw new JobConfigurationException("Can not find job error handler type '%s'.", type);
        }
        return HANDLERS.get(type);
    }

    @Generated
    private JobErrorHandlerFactory() {
    }

    static {
        for (JobErrorHandler each : ServiceLoader.load(JobErrorHandler.class)) {
            HANDLERS.put(each.getType(), each);
        }
    }
}

