/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.reg;

import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;

public final class RegistryCenterFactory {
    private static final ConcurrentHashMap<HashCode, CoordinatorRegistryCenter> REG_CENTER_REGISTRY = new ConcurrentHashMap();

    public static CoordinatorRegistryCenter createCoordinatorRegistryCenter(String connectString, String namespace, String digest) {
        HashCode hashCode;
        CoordinatorRegistryCenter result;
        Hasher hasher = Hashing.sha256().newHasher().putString((CharSequence)connectString, StandardCharsets.UTF_8).putString((CharSequence)namespace, StandardCharsets.UTF_8);
        if (!Strings.isNullOrEmpty((String)digest)) {
            hasher.putString((CharSequence)digest, StandardCharsets.UTF_8);
        }
        if (null != (result = REG_CENTER_REGISTRY.get(hashCode = hasher.hash()))) {
            return result;
        }
        ZookeeperConfiguration zkConfig = new ZookeeperConfiguration(connectString, namespace);
        if (!Strings.isNullOrEmpty((String)digest)) {
            zkConfig.setDigest(digest);
        }
        result = new ZookeeperRegistryCenter(zkConfig);
        result.init();
        REG_CENTER_REGISTRY.put(hashCode, result);
        return result;
    }

    @Generated
    private RegistryCenterFactory() {
    }
}

