/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.executor;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.api.listener.ShardingContexts;
import org.apache.shardingsphere.elasticjob.executor.JobFacade;
import org.apache.shardingsphere.elasticjob.executor.item.JobItemExecutor;
import org.apache.shardingsphere.elasticjob.executor.item.JobItemExecutorFactory;
import org.apache.shardingsphere.elasticjob.infra.env.IpUtils;
import org.apache.shardingsphere.elasticjob.infra.exception.ExceptionUtils;
import org.apache.shardingsphere.elasticjob.infra.exception.JobExecutionEnvironmentException;
import org.apache.shardingsphere.elasticjob.infra.handler.error.JobErrorHandler;
import org.apache.shardingsphere.elasticjob.infra.handler.error.JobErrorHandlerFactory;
import org.apache.shardingsphere.elasticjob.infra.handler.threadpool.JobExecutorServiceHandlerFactory;
import org.apache.shardingsphere.elasticjob.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticJobExecutor.class);
    private final ElasticJob elasticJob;
    private final JobConfiguration jobConfig;
    private final JobFacade jobFacade;
    private final JobItemExecutor jobItemExecutor;
    private final ExecutorService executorService;
    private final JobErrorHandler jobErrorHandler;
    private final Map<Integer, String> itemErrorMessages;

    public ElasticJobExecutor(ElasticJob elasticJob, JobConfiguration jobConfig, JobFacade jobFacade) {
        this(elasticJob, jobConfig, jobFacade, JobItemExecutorFactory.getExecutor(elasticJob.getClass()));
    }

    public ElasticJobExecutor(String type, JobConfiguration jobConfig, JobFacade jobFacade) {
        this(null, jobConfig, jobFacade, JobItemExecutorFactory.getExecutor(type));
    }

    private ElasticJobExecutor(ElasticJob elasticJob, JobConfiguration jobConfig, JobFacade jobFacade, JobItemExecutor jobItemExecutor) {
        this.elasticJob = elasticJob;
        this.jobConfig = jobConfig;
        this.jobFacade = jobFacade;
        this.jobItemExecutor = jobItemExecutor;
        this.executorService = JobExecutorServiceHandlerFactory.getHandler((String)jobConfig.getJobExecutorServiceHandlerType()).createExecutorService(jobConfig.getJobName());
        this.jobErrorHandler = JobErrorHandlerFactory.getHandler((String)jobConfig.getJobErrorHandlerType());
        this.itemErrorMessages = new ConcurrentHashMap<Integer, String>(jobConfig.getShardingTotalCount(), 1.0f);
    }

    public void execute() {
        try {
            this.jobFacade.checkJobExecutionEnvironment();
        }
        catch (JobExecutionEnvironmentException cause) {
            this.jobErrorHandler.handleException(this.jobConfig.getJobName(), (Throwable)cause);
        }
        ShardingContexts shardingContexts = this.jobFacade.getShardingContexts();
        this.jobFacade.postJobStatusTraceEvent(shardingContexts.getTaskId(), JobStatusTraceEvent.State.TASK_STAGING, String.format("Job '%s' execute begin.", this.jobConfig.getJobName()));
        if (this.jobFacade.misfireIfRunning(shardingContexts.getShardingItemParameters().keySet())) {
            this.jobFacade.postJobStatusTraceEvent(shardingContexts.getTaskId(), JobStatusTraceEvent.State.TASK_FINISHED, String.format("Previous job '%s' - shardingItems '%s' is still running, misfired job will start after previous job completed.", this.jobConfig.getJobName(), shardingContexts.getShardingItemParameters().keySet()));
            return;
        }
        try {
            this.jobFacade.beforeJobExecuted(shardingContexts);
        }
        catch (Throwable cause) {
            this.jobErrorHandler.handleException(this.jobConfig.getJobName(), cause);
        }
        this.execute(shardingContexts, JobExecutionEvent.ExecutionSource.NORMAL_TRIGGER);
        while (this.jobFacade.isExecuteMisfired(shardingContexts.getShardingItemParameters().keySet())) {
            this.jobFacade.clearMisfire(shardingContexts.getShardingItemParameters().keySet());
            this.execute(shardingContexts, JobExecutionEvent.ExecutionSource.MISFIRE);
        }
        this.jobFacade.failoverIfNecessary();
        try {
            this.jobFacade.afterJobExecuted(shardingContexts);
        }
        catch (Throwable cause) {
            this.jobErrorHandler.handleException(this.jobConfig.getJobName(), cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(ShardingContexts shardingContexts, JobExecutionEvent.ExecutionSource executionSource) {
        if (shardingContexts.getShardingItemParameters().isEmpty()) {
            this.jobFacade.postJobStatusTraceEvent(shardingContexts.getTaskId(), JobStatusTraceEvent.State.TASK_FINISHED, String.format("Sharding item for job '%s' is empty.", this.jobConfig.getJobName()));
            return;
        }
        this.jobFacade.registerJobBegin(shardingContexts);
        String taskId = shardingContexts.getTaskId();
        this.jobFacade.postJobStatusTraceEvent(taskId, JobStatusTraceEvent.State.TASK_RUNNING, "");
        try {
            this.process(shardingContexts, executionSource);
        }
        finally {
            this.jobFacade.registerJobCompleted(shardingContexts);
            if (this.itemErrorMessages.isEmpty()) {
                this.jobFacade.postJobStatusTraceEvent(taskId, JobStatusTraceEvent.State.TASK_FINISHED, "");
            } else {
                this.jobFacade.postJobStatusTraceEvent(taskId, JobStatusTraceEvent.State.TASK_ERROR, this.itemErrorMessages.toString());
            }
        }
    }

    private void process(ShardingContexts shardingContexts, JobExecutionEvent.ExecutionSource executionSource) {
        Set items = shardingContexts.getShardingItemParameters().keySet();
        if (1 == items.size()) {
            int item = (Integer)shardingContexts.getShardingItemParameters().keySet().iterator().next();
            JobExecutionEvent jobExecutionEvent = new JobExecutionEvent(IpUtils.getHostName(), IpUtils.getIp(), shardingContexts.getTaskId(), this.jobConfig.getJobName(), executionSource, item);
            this.process(shardingContexts, item, jobExecutionEvent);
            return;
        }
        CountDownLatch latch = new CountDownLatch(items.size());
        Iterator jobExecutionEvent = items.iterator();
        while (jobExecutionEvent.hasNext()) {
            int each = (Integer)jobExecutionEvent.next();
            JobExecutionEvent jobExecutionEvent2 = new JobExecutionEvent(IpUtils.getHostName(), IpUtils.getIp(), shardingContexts.getTaskId(), this.jobConfig.getJobName(), executionSource, each);
            if (this.executorService.isShutdown()) {
                return;
            }
            this.executorService.submit(() -> {
                try {
                    this.process(shardingContexts, each, jobExecutionEvent2);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void process(ShardingContexts shardingContexts, int item, JobExecutionEvent startEvent) {
        this.jobFacade.postJobExecutionEvent(startEvent);
        log.trace("Job '{}' executing, item is: '{}'.", (Object)this.jobConfig.getJobName(), (Object)item);
        try {
            this.jobItemExecutor.process(this.elasticJob, this.jobConfig, this.jobFacade, shardingContexts.createShardingContext(item));
            JobExecutionEvent completeEvent = startEvent.executionSuccess();
            log.trace("Job '{}' executed, item is: '{}'.", (Object)this.jobConfig.getJobName(), (Object)item);
            this.jobFacade.postJobExecutionEvent(completeEvent);
        }
        catch (Throwable cause) {
            JobExecutionEvent completeEvent = startEvent.executionFailure(ExceptionUtils.transform((Throwable)cause));
            this.jobFacade.postJobExecutionEvent(completeEvent);
            this.itemErrorMessages.put(item, ExceptionUtils.transform((Throwable)cause));
            this.jobErrorHandler.handleException(this.jobConfig.getJobName(), cause);
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

