/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.sharding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.api.listener.ShardingContexts;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingNode;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ExecutionService {
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;

    public ExecutionService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    public void registerJobBegin(ShardingContexts shardingContexts) {
        JobRegistry.getInstance().setJobRunning(this.jobName, true);
        if (!this.configService.load(true).isMonitorExecution()) {
            return;
        }
        Iterator iterator = shardingContexts.getShardingItemParameters().keySet().iterator();
        while (iterator.hasNext()) {
            int each = (Integer)iterator.next();
            this.jobNodeStorage.fillEphemeralJobNode(ShardingNode.getRunningNode(each), "");
        }
    }

    public void registerJobCompleted(ShardingContexts shardingContexts) {
        JobRegistry.getInstance().setJobRunning(this.jobName, false);
        if (!this.configService.load(true).isMonitorExecution()) {
            return;
        }
        Iterator iterator = shardingContexts.getShardingItemParameters().keySet().iterator();
        while (iterator.hasNext()) {
            int each = (Integer)iterator.next();
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getRunningNode(each));
        }
    }

    public void clearAllRunningInfo() {
        this.clearRunningInfo(this.getAllItems());
    }

    public void clearRunningInfo(List<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getRunningNode(each));
        }
    }

    public boolean hasRunningItems(Collection<Integer> items) {
        JobConfiguration jobConfig = this.configService.load(true);
        if (!jobConfig.isMonitorExecution()) {
            return false;
        }
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getRunningNode(each))) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningItems() {
        return this.hasRunningItems(this.getAllItems());
    }

    private List<Integer> getAllItems() {
        int shardingTotalCount = this.configService.load(true).getShardingTotalCount();
        ArrayList<Integer> result = new ArrayList<Integer>(shardingTotalCount);
        for (int i = 0; i < shardingTotalCount; ++i) {
            result.add(i);
        }
        return result;
    }

    public boolean misfireIfHasRunningItems(Collection<Integer> items) {
        if (!this.hasRunningItems(items)) {
            return false;
        }
        this.setMisfire(items);
        return true;
    }

    public void setMisfire(Collection<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.createJobNodeIfNeeded(ShardingNode.getMisfireNode(each));
        }
    }

    public List<Integer> getMisfiredJobItems(Collection<Integer> items) {
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getMisfireNode(each))) continue;
            result.add(each);
        }
        return result;
    }

    public void clearMisfire(Collection<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getMisfireNode(each));
        }
    }

    public List<Integer> getDisabledItems(List<Integer> items) {
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getDisabledNode(each))) continue;
            result.add(each);
        }
        return result;
    }
}

