/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.sharding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.api.listener.ShardingContexts;
import org.apache.shardingsphere.elasticjob.infra.context.ShardingItemParameters;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingNode;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ExecutionContextService {
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;

    public ExecutionContextService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    public ShardingContexts getJobShardingContext(List<Integer> shardingItems) {
        JobConfiguration jobConfig = this.configService.load(false);
        this.removeRunningIfMonitorExecution(jobConfig.isMonitorExecution(), shardingItems);
        if (shardingItems.isEmpty()) {
            return new ShardingContexts(this.buildTaskId(jobConfig, shardingItems), jobConfig.getJobName(), jobConfig.getShardingTotalCount(), jobConfig.getJobParameter(), Collections.emptyMap());
        }
        Map shardingItemParameterMap = new ShardingItemParameters(jobConfig.getShardingItemParameters()).getMap();
        return new ShardingContexts(this.buildTaskId(jobConfig, shardingItems), jobConfig.getJobName(), jobConfig.getShardingTotalCount(), jobConfig.getJobParameter(), this.getAssignedShardingItemParameterMap(shardingItems, shardingItemParameterMap));
    }

    private String buildTaskId(JobConfiguration jobConfig, List<Integer> shardingItems) {
        JobInstance jobInstance = JobRegistry.getInstance().getJobInstance(this.jobName);
        String shardingItemsString = shardingItems.stream().map(Object::toString).collect(Collectors.joining(","));
        String jobInstanceId = null == jobInstance.getJobInstanceId() ? "127.0.0.1@-@1" : jobInstance.getJobInstanceId();
        return String.join((CharSequence)"@-@", jobConfig.getJobName(), shardingItemsString, "READY", jobInstanceId);
    }

    private void removeRunningIfMonitorExecution(boolean monitorExecution, List<Integer> shardingItems) {
        if (!monitorExecution) {
            return;
        }
        ArrayList<Integer> runningShardingItems = new ArrayList<Integer>(shardingItems.size());
        for (int each : shardingItems) {
            if (!this.isRunning(each)) continue;
            runningShardingItems.add(each);
        }
        shardingItems.removeAll(runningShardingItems);
    }

    private boolean isRunning(int shardingItem) {
        return this.jobNodeStorage.isJobNodeExisted(ShardingNode.getRunningNode(shardingItem));
    }

    private Map<Integer, String> getAssignedShardingItemParameterMap(List<Integer> shardingItems, Map<Integer, String> shardingItemParameterMap) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(shardingItems.size(), 1.0f);
        for (int each : shardingItems) {
            result.put(each, shardingItemParameterMap.get(each));
        }
        return result;
    }
}

