/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.server;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.shardingsphere.elasticjob.infra.concurrent.BlockUtils;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerNode;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerStatus;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ServerService {
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final ServerNode serverNode;

    public ServerService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.serverNode = new ServerNode(jobName);
    }

    public void persistOnline(boolean enabled) {
        if (!JobRegistry.getInstance().isShutdown(this.jobName)) {
            this.jobNodeStorage.fillJobNode(this.serverNode.getServerNode(JobRegistry.getInstance().getJobInstance(this.jobName).getIp()), enabled ? ServerStatus.ENABLED.name() : ServerStatus.DISABLED.name());
        }
    }

    public boolean hasAvailableServers() {
        List<String> servers = this.jobNodeStorage.getJobNodeChildrenKeys("servers");
        for (String each : servers) {
            if (!this.isAvailableServer(each)) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailableServer(String ip) {
        return this.isEnableServer(ip) && this.hasOnlineInstances(ip);
    }

    private boolean hasOnlineInstances(String ip) {
        for (String each : this.jobNodeStorage.getJobNodeChildrenKeys("instances")) {
            if (!each.startsWith(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnableServer(String ip) {
        String serverStatus = this.jobNodeStorage.getJobNodeData(this.serverNode.getServerNode(ip));
        while (Strings.isNullOrEmpty((String)serverStatus)) {
            BlockUtils.waitingShortTime();
            serverStatus = this.jobNodeStorage.getJobNodeData(this.serverNode.getServerNode(ip));
        }
        return !ServerStatus.DISABLED.name().equals(serverStatus);
    }
}

