/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.schedule;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.api.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.executor.ElasticJobExecutor;
import org.apache.shardingsphere.elasticjob.executor.JobFacade;
import org.apache.shardingsphere.elasticjob.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.lite.api.listener.AbstractDistributeOnceElasticJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.guarantee.GuaranteeService;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobScheduleController;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobShutdownHookPlugin;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.LiteJob;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.LiteJobFacade;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.SchedulerFacade;
import org.apache.shardingsphere.elasticjob.lite.internal.setup.JobClassNameProviderFactory;
import org.apache.shardingsphere.elasticjob.lite.internal.setup.SetUpFacade;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;

public final class JobScheduler {
    private static final String JOB_EXECUTOR_DATA_MAP_KEY = "jobExecutor";
    private final CoordinatorRegistryCenter regCenter;
    private final ElasticJob elasticJob;
    private final String elasticJobType;
    private final JobConfiguration jobConfig;
    private final List<ElasticJobListener> elasticJobListeners;
    private final SetUpFacade setUpFacade;
    private final SchedulerFacade schedulerFacade;
    private final LiteJobFacade jobFacade;
    private final ElasticJobExecutor jobExecutor;
    private final JobScheduleController jobScheduleController;

    public JobScheduler(CoordinatorRegistryCenter regCenter, ElasticJob elasticJob, JobConfiguration jobConfig, ElasticJobListener ... elasticJobListeners) {
        this(regCenter, elasticJob, jobConfig, (TracingConfiguration<?>)null, elasticJobListeners);
    }

    public JobScheduler(CoordinatorRegistryCenter regCenter, ElasticJob elasticJob, JobConfiguration jobConfig, TracingConfiguration<?> tracingConfig, ElasticJobListener ... elasticJobListeners) {
        this.regCenter = regCenter;
        this.elasticJob = elasticJob;
        this.elasticJobType = null;
        this.elasticJobListeners = Arrays.asList(elasticJobListeners);
        this.setUpFacade = new SetUpFacade(regCenter, jobConfig.getJobName(), this.elasticJobListeners);
        this.schedulerFacade = new SchedulerFacade(regCenter, jobConfig.getJobName());
        this.jobFacade = new LiteJobFacade(regCenter, jobConfig.getJobName(), this.elasticJobListeners, tracingConfig);
        this.jobExecutor = null == elasticJob ? new ElasticJobExecutor(this.elasticJobType, jobConfig, (JobFacade)this.jobFacade) : new ElasticJobExecutor(elasticJob, jobConfig, (JobFacade)this.jobFacade);
        String jobClassName = JobClassNameProviderFactory.getProvider().getJobClassName(elasticJob);
        this.jobConfig = this.setUpFacade.setUpJobConfiguration(jobClassName, jobConfig);
        this.setGuaranteeServiceForElasticJobListeners(regCenter, this.elasticJobListeners);
        this.jobScheduleController = this.createJobScheduleController();
    }

    public JobScheduler(CoordinatorRegistryCenter regCenter, String elasticJobType, JobConfiguration jobConfig, ElasticJobListener ... elasticJobListeners) {
        this(regCenter, elasticJobType, jobConfig, (TracingConfiguration<?>)null, elasticJobListeners);
    }

    public JobScheduler(CoordinatorRegistryCenter regCenter, String elasticJobType, JobConfiguration jobConfig, TracingConfiguration<?> tracingConfig, ElasticJobListener ... elasticJobListeners) {
        this.regCenter = regCenter;
        this.elasticJob = null;
        this.elasticJobType = elasticJobType;
        this.elasticJobListeners = Arrays.asList(elasticJobListeners);
        this.setUpFacade = new SetUpFacade(regCenter, jobConfig.getJobName(), this.elasticJobListeners);
        this.schedulerFacade = new SchedulerFacade(regCenter, jobConfig.getJobName());
        this.jobFacade = new LiteJobFacade(regCenter, jobConfig.getJobName(), this.elasticJobListeners, tracingConfig);
        this.jobExecutor = null == this.elasticJob ? new ElasticJobExecutor(elasticJobType, jobConfig, (JobFacade)this.jobFacade) : new ElasticJobExecutor(this.elasticJob, jobConfig, (JobFacade)this.jobFacade);
        this.jobConfig = this.setUpFacade.setUpJobConfiguration(elasticJobType, jobConfig);
        this.setGuaranteeServiceForElasticJobListeners(regCenter, this.elasticJobListeners);
        this.jobScheduleController = this.createJobScheduleController();
    }

    private void setGuaranteeServiceForElasticJobListeners(CoordinatorRegistryCenter regCenter, List<ElasticJobListener> elasticJobListeners) {
        GuaranteeService guaranteeService = new GuaranteeService(regCenter, this.jobConfig.getJobName());
        for (ElasticJobListener each : elasticJobListeners) {
            if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
            ((AbstractDistributeOnceElasticJobListener)each).setGuaranteeService(guaranteeService);
        }
    }

    private JobScheduleController createJobScheduleController() {
        JobScheduleController result = new JobScheduleController(this.createScheduler(), this.createJobDetail(), this.getJobConfig().getJobName());
        JobRegistry.getInstance().registerJob(this.getJobConfig().getJobName(), result);
        this.registerStartUpInfo();
        return result;
    }

    private Scheduler createScheduler() {
        Scheduler result;
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            factory.initialize(this.getQuartzProps());
            result = factory.getScheduler();
            result.getListenerManager().addTriggerListener((TriggerListener)this.schedulerFacade.newJobTriggerListener());
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
        return result;
    }

    private Properties getQuartzProps() {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        result.put("org.quartz.threadPool.threadCount", "1");
        result.put("org.quartz.scheduler.instanceName", this.getJobConfig().getJobName());
        result.put("org.quartz.jobStore.misfireThreshold", "1");
        result.put("org.quartz.plugin.shutdownhook.class", JobShutdownHookPlugin.class.getName());
        result.put("org.quartz.plugin.shutdownhook.cleanShutdown", Boolean.TRUE.toString());
        return result;
    }

    private JobDetail createJobDetail() {
        JobDetail result = JobBuilder.newJob(LiteJob.class).withIdentity(this.getJobConfig().getJobName()).build();
        result.getJobDataMap().put(JOB_EXECUTOR_DATA_MAP_KEY, (Object)this.jobExecutor);
        return result;
    }

    private void registerStartUpInfo() {
        JobRegistry.getInstance().registerRegistryCenter(this.jobConfig.getJobName(), this.regCenter);
        JobRegistry.getInstance().addJobInstance(this.jobConfig.getJobName(), new JobInstance());
        JobRegistry.getInstance().setCurrentShardingTotalCount(this.jobConfig.getJobName(), this.jobConfig.getShardingTotalCount());
        this.setUpFacade.registerStartUpInfo(!this.jobConfig.isDisabled());
    }

    public void shutdown() {
        this.schedulerFacade.shutdownInstance();
        this.jobExecutor.shutdown();
    }

    @Generated
    public JobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Generated
    public JobScheduleController getJobScheduleController() {
        return this.jobScheduleController;
    }
}

