/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.schedule;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobScheduleController;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class JobRegistry {
    private static volatile JobRegistry instance;
    private final Map<String, JobScheduleController> schedulerMap = new ConcurrentHashMap<String, JobScheduleController>();
    private final Map<String, CoordinatorRegistryCenter> regCenterMap = new ConcurrentHashMap<String, CoordinatorRegistryCenter>();
    private final Map<String, JobInstance> jobInstanceMap = new ConcurrentHashMap<String, JobInstance>();
    private final Map<String, Boolean> jobRunningMap = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Integer> currentShardingTotalCountMap = new ConcurrentHashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobRegistry getInstance() {
        if (null != instance) return instance;
        Class<JobRegistry> clazz = JobRegistry.class;
        synchronized (JobRegistry.class) {
            if (null != instance) return instance;
            instance = new JobRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerRegistryCenter(String jobName, CoordinatorRegistryCenter regCenter) {
        this.regCenterMap.put(jobName, regCenter);
        regCenter.addCacheData("/" + jobName);
    }

    public void registerJob(String jobName, JobScheduleController jobScheduleController) {
        this.schedulerMap.put(jobName, jobScheduleController);
    }

    public JobScheduleController getJobScheduleController(String jobName) {
        return this.schedulerMap.get(jobName);
    }

    public CoordinatorRegistryCenter getRegCenter(String jobName) {
        return this.regCenterMap.get(jobName);
    }

    public void addJobInstance(String jobName, JobInstance jobInstance) {
        this.jobInstanceMap.put(jobName, jobInstance);
    }

    public JobInstance getJobInstance(String jobName) {
        return this.jobInstanceMap.get(jobName);
    }

    public boolean isJobRunning(String jobName) {
        Boolean result = this.jobRunningMap.get(jobName);
        return null == result ? false : result;
    }

    public void setJobRunning(String jobName, boolean isRunning) {
        this.jobRunningMap.put(jobName, isRunning);
    }

    public int getCurrentShardingTotalCount(String jobName) {
        Integer result = this.currentShardingTotalCountMap.get(jobName);
        return null == result ? 0 : result;
    }

    public void setCurrentShardingTotalCount(String jobName, int currentShardingTotalCount) {
        this.currentShardingTotalCountMap.put(jobName, currentShardingTotalCount);
    }

    public void shutdown(String jobName) {
        CoordinatorRegistryCenter regCenter;
        JobScheduleController scheduleController = this.schedulerMap.remove(jobName);
        if (null != scheduleController) {
            scheduleController.shutdown();
        }
        if (null != (regCenter = this.regCenterMap.remove(jobName))) {
            regCenter.evictCacheData("/" + jobName);
        }
        this.jobInstanceMap.remove(jobName);
        this.jobRunningMap.remove(jobName);
        this.currentShardingTotalCountMap.remove(jobName);
    }

    public boolean isShutdown(String jobName) {
        return !this.schedulerMap.containsKey(jobName) || !this.jobInstanceMap.containsKey(jobName);
    }

    @Generated
    private JobRegistry() {
    }
}

