/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.guarantee;

import java.util.List;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.api.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.lite.api.listener.AbstractDistributeOnceElasticJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.guarantee.GuaranteeNode;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class GuaranteeListenerManager
extends AbstractListenerManager {
    private final GuaranteeNode guaranteeNode;
    private final List<ElasticJobListener> elasticJobListeners;

    public GuaranteeListenerManager(CoordinatorRegistryCenter regCenter, String jobName, List<ElasticJobListener> elasticJobListeners) {
        super(regCenter, jobName);
        this.guaranteeNode = new GuaranteeNode(jobName);
        this.elasticJobListeners = elasticJobListeners;
    }

    @Override
    public void start() {
        this.addDataListener(new StartedNodeRemovedJobListener());
        this.addDataListener(new CompletedNodeRemovedJobListener());
    }

    class CompletedNodeRemovedJobListener
    extends AbstractJobListener {
        CompletedNodeRemovedJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (CuratorCacheListener.Type.NODE_DELETED == eventType && GuaranteeListenerManager.this.guaranteeNode.isCompletedRootNode(path)) {
                for (ElasticJobListener each : GuaranteeListenerManager.this.elasticJobListeners) {
                    if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
                    ((AbstractDistributeOnceElasticJobListener)each).notifyWaitingTaskComplete();
                }
            }
        }
    }

    class StartedNodeRemovedJobListener
    extends AbstractJobListener {
        StartedNodeRemovedJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (CuratorCacheListener.Type.NODE_DELETED == eventType && GuaranteeListenerManager.this.guaranteeNode.isStartedRootNode(path)) {
                for (ElasticJobListener each : GuaranteeListenerManager.this.elasticJobListeners) {
                    if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
                    ((AbstractDistributeOnceElasticJobListener)each).notifyWaitingTaskStart();
                }
            }
        }
    }
}

