/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.executor.item;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.executor.item.JobItemExecutor;
import org.apache.shardingsphere.elasticjob.executor.item.impl.ClassedJobItemExecutor;
import org.apache.shardingsphere.elasticjob.executor.item.impl.TypedJobItemExecutor;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;

public final class JobItemExecutorFactory {
    private static final Map<Class, ClassedJobItemExecutor> CLASSED_EXECUTORS = new ConcurrentHashMap<Class, ClassedJobItemExecutor>();
    private static final Map<String, TypedJobItemExecutor> TYPED_EXECUTORS = new ConcurrentHashMap<String, TypedJobItemExecutor>();

    public static JobItemExecutor getExecutor(Class<? extends ElasticJob> elasticJobClass) {
        for (Map.Entry<Class, ClassedJobItemExecutor> entry : CLASSED_EXECUTORS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(elasticJobClass)) continue;
            return entry.getValue();
        }
        throw new JobConfigurationException("Can not find executor for elastic job class `%s`", new Object[]{elasticJobClass.getName()});
    }

    public static JobItemExecutor getExecutor(String elasticJobType) {
        for (Map.Entry<String, TypedJobItemExecutor> entry : TYPED_EXECUTORS.entrySet()) {
            if (!entry.getKey().equals(elasticJobType)) continue;
            return entry.getValue();
        }
        throw new JobConfigurationException("Can not find executor for elastic job type `%s`", new Object[]{elasticJobType});
    }

    @Generated
    private JobItemExecutorFactory() {
    }

    static {
        for (JobItemExecutor each : ServiceLoader.load(JobItemExecutor.class)) {
            JobItemExecutor typedJobItemExecutor;
            if (each instanceof ClassedJobItemExecutor) {
                typedJobItemExecutor = (ClassedJobItemExecutor)each;
                CLASSED_EXECUTORS.put(typedJobItemExecutor.getElasticJobClass(), (ClassedJobItemExecutor)typedJobItemExecutor);
            }
            if (!(each instanceof TypedJobItemExecutor)) continue;
            typedJobItemExecutor = (TypedJobItemExecutor)each;
            TYPED_EXECUTORS.put(typedJobItemExecutor.getType(), (TypedJobItemExecutor)typedJobItemExecutor);
        }
    }
}

