/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.tracing.rdb.storage;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.apache.shardingsphere.elasticjob.tracing.rdb.storage.RDBStorageSQLMapper;
import org.apache.shardingsphere.elasticjob.tracing.rdb.type.DatabaseType;
import org.apache.shardingsphere.elasticjob.tracing.rdb.type.impl.DefaultDatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDBJobEventStorage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RDBJobEventStorage.class);
    private static final String TABLE_JOB_EXECUTION_LOG = "JOB_EXECUTION_LOG";
    private static final String TABLE_JOB_STATUS_TRACE_LOG = "JOB_STATUS_TRACE_LOG";
    private static final String TASK_ID_STATE_INDEX = "TASK_ID_STATE_INDEX";
    private static final Map<String, DatabaseType> DATABASE_TYPES = new HashMap<String, DatabaseType>();
    private final DataSource dataSource;
    private final DatabaseType databaseType;
    private final RDBStorageSQLMapper sqlMapper;

    public RDBJobEventStorage(DataSource dataSource) throws SQLException {
        this.dataSource = dataSource;
        this.databaseType = this.getDatabaseType(dataSource);
        this.sqlMapper = new RDBStorageSQLMapper(this.databaseType.getSQLPropertiesFile());
        this.initTablesAndIndexes();
    }

    private DatabaseType getDatabaseType(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            for (DatabaseType each : DATABASE_TYPES.values()) {
                if (!each.getDatabaseProductName().equals(databaseProductName)) continue;
                DatabaseType databaseType = each;
                return databaseType;
            }
        }
        return new DefaultDatabaseType();
    }

    private void initTablesAndIndexes() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            this.createJobExecutionTableAndIndexIfNeeded(connection);
            this.createJobStatusTraceTableAndIndexIfNeeded(connection);
        }
    }

    private void createJobExecutionTableAndIndexIfNeeded(Connection connection) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        try (ResultSet resultSet = dbMetaData.getTables(connection.getCatalog(), null, TABLE_JOB_EXECUTION_LOG, new String[]{"TABLE"});){
            if (!resultSet.next()) {
                this.createJobExecutionTable(connection);
            }
        }
    }

    private void createJobStatusTraceTableAndIndexIfNeeded(Connection connection) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        try (ResultSet resultSet = dbMetaData.getTables(connection.getCatalog(), null, TABLE_JOB_STATUS_TRACE_LOG, new String[]{"TABLE"});){
            if (!resultSet.next()) {
                this.createJobStatusTraceTable(connection);
            }
        }
        this.createTaskIdIndexIfNeeded(connection);
    }

    private void createTaskIdIndexIfNeeded(Connection connection) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        try (ResultSet resultSet = dbMetaData.getIndexInfo(connection.getCatalog(), null, TABLE_JOB_STATUS_TRACE_LOG, false, false);){
            boolean hasTaskIdIndex = false;
            while (resultSet.next()) {
                if (!TASK_ID_STATE_INDEX.equals(resultSet.getString("INDEX_NAME"))) continue;
                hasTaskIdIndex = true;
            }
            if (!hasTaskIdIndex) {
                this.createTaskIdAndStateIndex(connection);
            }
        }
    }

    private void createJobExecutionTable(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getCreateTableForJobExecutionLog());){
            preparedStatement.execute();
        }
    }

    private void createJobStatusTraceTable(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getCreateTableForJobStatusTraceLog());){
            preparedStatement.execute();
        }
    }

    private void createTaskIdAndStateIndex(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getCreateIndexForTaskIdStateIndex());){
            preparedStatement.execute();
        }
    }

    public boolean addJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        if (null == jobExecutionEvent.getCompleteTime()) {
            return this.insertJobExecutionEvent(jobExecutionEvent);
        }
        if (jobExecutionEvent.isSuccess()) {
            return this.updateJobExecutionEventWhenSuccess(jobExecutionEvent);
        }
        return this.updateJobExecutionEventFailure(jobExecutionEvent);
    }

    private boolean insertJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        boolean result;
        block26: {
            result = false;
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getInsertForJobExecutionLog());){
                preparedStatement.setString(1, jobExecutionEvent.getId());
                preparedStatement.setString(2, jobExecutionEvent.getJobName());
                preparedStatement.setString(3, jobExecutionEvent.getTaskId());
                preparedStatement.setString(4, jobExecutionEvent.getHostname());
                preparedStatement.setString(5, jobExecutionEvent.getIp());
                preparedStatement.setInt(6, jobExecutionEvent.getShardingItem());
                preparedStatement.setString(7, jobExecutionEvent.getSource().toString());
                preparedStatement.setBoolean(8, jobExecutionEvent.isSuccess());
                preparedStatement.setTimestamp(9, new Timestamp(jobExecutionEvent.getStartTime().getTime()));
                preparedStatement.execute();
                result = true;
            }
            catch (SQLException ex) {
                if (this.isDuplicateRecord(ex)) break block26;
                log.error(ex.getMessage());
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateJobExecutionEventWhenSuccess(JobExecutionEvent jobExecutionEvent) {
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getUpdateForJobExecutionLog());){
            preparedStatement.setBoolean(1, jobExecutionEvent.isSuccess());
            preparedStatement.setTimestamp(2, new Timestamp(jobExecutionEvent.getCompleteTime().getTime()));
            preparedStatement.setString(3, jobExecutionEvent.getId());
            if (0 == preparedStatement.executeUpdate()) {
                boolean bl = this.insertJobExecutionEventWhenSuccess(jobExecutionEvent);
                return bl;
            }
            result = true;
            return result;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    private boolean insertJobExecutionEventWhenSuccess(JobExecutionEvent jobExecutionEvent) {
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getInsertForJobExecutionLogForComplete());){
            preparedStatement.setString(1, jobExecutionEvent.getId());
            preparedStatement.setString(2, jobExecutionEvent.getJobName());
            preparedStatement.setString(3, jobExecutionEvent.getTaskId());
            preparedStatement.setString(4, jobExecutionEvent.getHostname());
            preparedStatement.setString(5, jobExecutionEvent.getIp());
            preparedStatement.setInt(6, jobExecutionEvent.getShardingItem());
            preparedStatement.setString(7, jobExecutionEvent.getSource().toString());
            preparedStatement.setBoolean(8, jobExecutionEvent.isSuccess());
            preparedStatement.setTimestamp(9, new Timestamp(jobExecutionEvent.getStartTime().getTime()));
            preparedStatement.setTimestamp(10, new Timestamp(jobExecutionEvent.getCompleteTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            if (this.isDuplicateRecord(ex)) {
                return this.updateJobExecutionEventWhenSuccess(jobExecutionEvent);
            }
            log.error(ex.getMessage());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateJobExecutionEventFailure(JobExecutionEvent jobExecutionEvent) {
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getUpdateForJobExecutionLogForFailure());){
            preparedStatement.setBoolean(1, jobExecutionEvent.isSuccess());
            preparedStatement.setTimestamp(2, new Timestamp(jobExecutionEvent.getCompleteTime().getTime()));
            preparedStatement.setString(3, this.truncateString(jobExecutionEvent.getFailureCause()));
            preparedStatement.setString(4, jobExecutionEvent.getId());
            if (0 == preparedStatement.executeUpdate()) {
                boolean bl = this.insertJobExecutionEventWhenFailure(jobExecutionEvent);
                return bl;
            }
            result = true;
            return result;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    private boolean insertJobExecutionEventWhenFailure(JobExecutionEvent jobExecutionEvent) {
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getInsertForJobExecutionLogForFailure());){
            preparedStatement.setString(1, jobExecutionEvent.getId());
            preparedStatement.setString(2, jobExecutionEvent.getJobName());
            preparedStatement.setString(3, jobExecutionEvent.getTaskId());
            preparedStatement.setString(4, jobExecutionEvent.getHostname());
            preparedStatement.setString(5, jobExecutionEvent.getIp());
            preparedStatement.setInt(6, jobExecutionEvent.getShardingItem());
            preparedStatement.setString(7, jobExecutionEvent.getSource().toString());
            preparedStatement.setString(8, this.truncateString(jobExecutionEvent.getFailureCause()));
            preparedStatement.setBoolean(9, jobExecutionEvent.isSuccess());
            preparedStatement.setTimestamp(10, new Timestamp(jobExecutionEvent.getStartTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            if (this.isDuplicateRecord(ex)) {
                return this.updateJobExecutionEventFailure(jobExecutionEvent);
            }
            log.error(ex.getMessage());
        }
        return result;
    }

    private boolean isDuplicateRecord(SQLException ex) {
        return null != this.databaseType && this.databaseType.getDuplicateRecordErrorCode() == ex.getErrorCode();
    }

    public boolean addJobStatusTraceEvent(JobStatusTraceEvent jobStatusTraceEvent) {
        String originalTaskId = jobStatusTraceEvent.getOriginalTaskId();
        if (JobStatusTraceEvent.State.TASK_STAGING != jobStatusTraceEvent.getState()) {
            originalTaskId = this.getOriginalTaskId(jobStatusTraceEvent.getTaskId());
        }
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getInsertForJobStatusTraceLog());){
            preparedStatement.setString(1, UUID.randomUUID().toString());
            preparedStatement.setString(2, jobStatusTraceEvent.getJobName());
            preparedStatement.setString(3, originalTaskId);
            preparedStatement.setString(4, jobStatusTraceEvent.getTaskId());
            preparedStatement.setString(5, jobStatusTraceEvent.getSlaveId());
            preparedStatement.setString(6, jobStatusTraceEvent.getSource().toString());
            preparedStatement.setString(7, jobStatusTraceEvent.getExecutionType());
            preparedStatement.setString(8, jobStatusTraceEvent.getShardingItems());
            preparedStatement.setString(9, jobStatusTraceEvent.getState().toString());
            preparedStatement.setString(10, this.truncateString(jobStatusTraceEvent.getMessage()));
            preparedStatement.setTimestamp(11, new Timestamp(jobStatusTraceEvent.getCreationTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOriginalTaskId(String taskId) {
        String result = "";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getSelectOriginalTaskIdForJobStatusTraceLog());){
            preparedStatement.setString(1, taskId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return result;
                String string = resultSet.getString("original_task_id");
                return string;
            }
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    private String truncateString(String str) {
        return !Strings.isNullOrEmpty((String)str) && str.length() > 4000 ? str.substring(0, 4000) : str;
    }

    List<JobStatusTraceEvent> getJobStatusTraceEvents(String taskId) {
        ArrayList<JobStatusTraceEvent> result = new ArrayList<JobStatusTraceEvent>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getSelectForJobStatusTraceLog());){
            preparedStatement.setString(1, taskId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    JobStatusTraceEvent jobStatusTraceEvent = new JobStatusTraceEvent(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), JobStatusTraceEvent.Source.valueOf((String)resultSet.getString(6)), resultSet.getString(7), resultSet.getString(8), JobStatusTraceEvent.State.valueOf((String)resultSet.getString(9)), resultSet.getString(10), new SimpleDateFormat("yyyy-mm-dd HH:MM:SS").parse(resultSet.getString(11)));
                    result.add(jobStatusTraceEvent);
                }
            }
        }
        catch (SQLException | ParseException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    static {
        for (DatabaseType each : ServiceLoader.load(DatabaseType.class)) {
            DATABASE_TYPES.put(each.getType(), each);
        }
    }
}

