/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.security;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shardingsphere.elasticjob.cloud.ui.security.AuthenticationResult;
import org.apache.shardingsphere.elasticjob.cloud.ui.security.UserAccount;
import org.apache.shardingsphere.elasticjob.cloud.ui.security.UserAuthenticationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.response.ResponseResultUtil;

public final class AuthenticationFilter
implements Filter {
    private static final String LOGIN_URI = "/api/login";
    private final Gson gson = new Gson();
    private UserAuthenticationService userAuthenticationService;

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        if (LOGIN_URI.equals(httpRequest.getRequestURI())) {
            this.handleLogin(httpRequest, httpResponse);
        } else {
            String accessToken = httpRequest.getHeader("Access-Token");
            if (!Strings.isNullOrEmpty((String)accessToken) && accessToken.equals(this.userAuthenticationService.getToken())) {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else {
                this.respondWithUnauthorized(httpResponse);
            }
        }
    }

    public void destroy() {
    }

    private void handleLogin(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            UserAccount user = (UserAccount)this.gson.fromJson((Reader)httpRequest.getReader(), UserAccount.class);
            AuthenticationResult authenticationResult = this.userAuthenticationService.checkUser(user);
            if (null != authenticationResult && authenticationResult.isSuccess()) {
                httpResponse.setContentType("application/json");
                httpResponse.setCharacterEncoding("UTF-8");
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("username", authenticationResult.getUsername());
                result.put("accessToken", this.userAuthenticationService.getToken());
                result.put("isGuest", authenticationResult.isGuest());
                httpResponse.getWriter().write(this.gson.toJson(ResponseResultUtil.build(result)));
            } else {
                this.respondWithUnauthorized(httpResponse);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void respondWithUnauthorized(HttpServletResponse httpResponse) throws IOException {
        httpResponse.setContentType("application/json");
        httpResponse.setCharacterEncoding("UTF-8");
        httpResponse.getWriter().write(new Gson().toJson((Object)ResponseResultUtil.handleUnauthorizedException("Unauthorized.")));
    }

    public void setUserAuthenticationService(UserAuthenticationService userAuthenticationService) {
        this.userAuthenticationService = userAuthenticationService;
    }
}

