/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.sharding;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.concurrent.BlockUtils;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobShardingStrategy;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobShardingStrategyFactory;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.election.LeaderService;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingNode;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.TransactionExecutionCallback;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingService.class);
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final LeaderService leaderService;
    private final ConfigurationService configService;
    private final InstanceService instanceService;
    private final ServerService serverService;
    private final ExecutionService executionService;
    private final JobNodePath jobNodePath;

    public ShardingService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.leaderService = new LeaderService(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.jobNodePath = new JobNodePath(jobName);
    }

    public void setReshardingFlag() {
        if (!this.leaderService.isLeaderUntilBlock()) {
            return;
        }
        this.jobNodeStorage.createJobNodeIfNeeded("leader/sharding/necessary");
    }

    public boolean isNeedSharding() {
        return this.jobNodeStorage.isJobNodeExisted("leader/sharding/necessary");
    }

    public void shardingIfNecessary() {
        List<JobInstance> availableJobInstances = this.instanceService.getAvailableJobInstances();
        if (!this.isNeedSharding() || availableJobInstances.isEmpty()) {
            return;
        }
        if (!this.leaderService.isLeaderUntilBlock()) {
            this.blockUntilShardingCompleted();
            return;
        }
        this.waitingOtherShardingItemCompleted();
        JobConfiguration jobConfig = this.configService.load(false);
        int shardingTotalCount = jobConfig.getShardingTotalCount();
        log.debug("Job '{}' sharding begin.", (Object)this.jobName);
        this.jobNodeStorage.fillEphemeralJobNode("leader/sharding/processing", "");
        this.resetShardingInfo(shardingTotalCount);
        JobShardingStrategy jobShardingStrategy = JobShardingStrategyFactory.getStrategy((String)jobConfig.getJobShardingStrategyType());
        this.jobNodeStorage.executeInTransaction(new PersistShardingInfoTransactionExecutionCallback(jobShardingStrategy.sharding(availableJobInstances, this.jobName, shardingTotalCount)));
        log.debug("Job '{}' sharding complete.", (Object)this.jobName);
    }

    private void blockUntilShardingCompleted() {
        while (!this.leaderService.isLeaderUntilBlock() && (this.jobNodeStorage.isJobNodeExisted("leader/sharding/necessary") || this.jobNodeStorage.isJobNodeExisted("leader/sharding/processing"))) {
            log.debug("Job '{}' sleep short time until sharding completed.", (Object)this.jobName);
            BlockUtils.waitingShortTime();
        }
    }

    private void waitingOtherShardingItemCompleted() {
        while (this.executionService.hasRunningItems()) {
            log.debug("Job '{}' sleep short time until other job completed.", (Object)this.jobName);
            BlockUtils.waitingShortTime();
        }
    }

    private void resetShardingInfo(int shardingTotalCount) {
        for (int i = 0; i < shardingTotalCount; ++i) {
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getInstanceNode(i));
            this.jobNodeStorage.createJobNodeIfNeeded("sharding/" + i);
        }
        int actualShardingTotalCount = this.jobNodeStorage.getJobNodeChildrenKeys("sharding").size();
        if (actualShardingTotalCount > shardingTotalCount) {
            for (int i = shardingTotalCount; i < actualShardingTotalCount; ++i) {
                this.jobNodeStorage.removeJobNodeIfExisted("sharding/" + i);
            }
        }
    }

    public List<Integer> getShardingItems(String jobInstanceId) {
        JobInstance jobInstance = new JobInstance(jobInstanceId);
        if (!this.serverService.isAvailableServer(jobInstance.getIp())) {
            return Collections.emptyList();
        }
        LinkedList<Integer> result = new LinkedList<Integer>();
        int shardingTotalCount = this.configService.load(true).getShardingTotalCount();
        for (int i = 0; i < shardingTotalCount; ++i) {
            if (!jobInstance.getJobInstanceId().equals(this.jobNodeStorage.getJobNodeData(ShardingNode.getInstanceNode(i)))) continue;
            result.add(i);
        }
        return result;
    }

    public List<Integer> getLocalShardingItems() {
        if (JobRegistry.getInstance().isShutdown(this.jobName) || !this.serverService.isAvailableServer(JobRegistry.getInstance().getJobInstance(this.jobName).getIp())) {
            return Collections.emptyList();
        }
        return this.getShardingItems(JobRegistry.getInstance().getJobInstance(this.jobName).getJobInstanceId());
    }

    public boolean hasShardingInfoInOfflineServers() {
        List<String> onlineInstances = this.jobNodeStorage.getJobNodeChildrenKeys("instances");
        int shardingTotalCount = this.configService.load(true).getShardingTotalCount();
        for (int i = 0; i < shardingTotalCount; ++i) {
            if (onlineInstances.contains(this.jobNodeStorage.getJobNodeData(ShardingNode.getInstanceNode(i)))) continue;
            return true;
        }
        return false;
    }

    class PersistShardingInfoTransactionExecutionCallback
    implements TransactionExecutionCallback {
        private final Map<JobInstance, List<Integer>> shardingResults;

        @Override
        public List<CuratorOp> createCuratorOperators(TransactionOp transactionOp) throws Exception {
            LinkedList<CuratorOp> result = new LinkedList<CuratorOp>();
            for (Map.Entry<JobInstance, List<Integer>> entry : this.shardingResults.entrySet()) {
                for (int shardingItem : entry.getValue()) {
                    result.add((CuratorOp)transactionOp.create().forPath(ShardingService.this.jobNodePath.getFullPath(ShardingNode.getInstanceNode(shardingItem)), entry.getKey().getJobInstanceId().getBytes()));
                }
            }
            result.add((CuratorOp)transactionOp.delete().forPath(ShardingService.this.jobNodePath.getFullPath("leader/sharding/necessary")));
            result.add((CuratorOp)transactionOp.delete().forPath(ShardingService.this.jobNodePath.getFullPath("leader/sharding/processing")));
            return result;
        }

        @Generated
        public PersistShardingInfoTransactionExecutionCallback(Map<JobInstance, List<Integer>> shardingResults) {
            this.shardingResults = shardingResults;
        }
    }
}

