/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.listener;

import java.util.Collection;
import org.apache.shardingsphere.elasticjob.infra.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.config.RescheduleListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.election.ElectionListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.failover.FailoverListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.guarantee.GuaranteeListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.ShutdownListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.TriggerListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.RegistryCenterConnectionStateListener;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.MonitorExecutionListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ListenerManager {
    private final JobNodeStorage jobNodeStorage;
    private final ElectionListenerManager electionListenerManager;
    private final ShardingListenerManager shardingListenerManager;
    private final FailoverListenerManager failoverListenerManager;
    private final MonitorExecutionListenerManager monitorExecutionListenerManager;
    private final ShutdownListenerManager shutdownListenerManager;
    private final TriggerListenerManager triggerListenerManager;
    private final RescheduleListenerManager rescheduleListenerManager;
    private final GuaranteeListenerManager guaranteeListenerManager;
    private final RegistryCenterConnectionStateListener regCenterConnectionStateListener;

    public ListenerManager(CoordinatorRegistryCenter regCenter, String jobName, Collection<ElasticJobListener> elasticJobListeners) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.electionListenerManager = new ElectionListenerManager(regCenter, jobName);
        this.shardingListenerManager = new ShardingListenerManager(regCenter, jobName);
        this.failoverListenerManager = new FailoverListenerManager(regCenter, jobName);
        this.monitorExecutionListenerManager = new MonitorExecutionListenerManager(regCenter, jobName);
        this.shutdownListenerManager = new ShutdownListenerManager(regCenter, jobName);
        this.triggerListenerManager = new TriggerListenerManager(regCenter, jobName);
        this.rescheduleListenerManager = new RescheduleListenerManager(regCenter, jobName);
        this.guaranteeListenerManager = new GuaranteeListenerManager(regCenter, jobName, elasticJobListeners);
        this.regCenterConnectionStateListener = new RegistryCenterConnectionStateListener(regCenter, jobName);
    }

    public void startAllListeners() {
        this.electionListenerManager.start();
        this.shardingListenerManager.start();
        this.failoverListenerManager.start();
        this.monitorExecutionListenerManager.start();
        this.shutdownListenerManager.start();
        this.triggerListenerManager.start();
        this.rescheduleListenerManager.start();
        this.guaranteeListenerManager.start();
        this.jobNodeStorage.addConnectionStateListener(this.regCenterConnectionStateListener);
    }
}

