/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.failover;

import java.util.List;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationNode;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.failover.FailoverService;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceNode;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class FailoverListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final FailoverService failoverService;
    private final ConfigurationNode configNode;
    private final InstanceNode instanceNode;

    public FailoverListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
        this.instanceNode = new InstanceNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new JobCrashedJobListener());
        this.addDataListener(new FailoverSettingsChangedJobListener());
    }

    private boolean isFailoverEnabled() {
        return this.configService.load(true).isFailover();
    }

    class FailoverSettingsChangedJobListener
    extends AbstractJobListener {
        FailoverSettingsChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (FailoverListenerManager.this.configNode.isConfigPath(path) && CuratorCacheListener.Type.NODE_CHANGED == eventType && !((JobConfigurationPOJO)YamlEngine.unmarshal((String)data, JobConfigurationPOJO.class)).toJobConfiguration().isFailover()) {
                FailoverListenerManager.this.failoverService.removeFailoverInfo();
            }
        }
    }

    class JobCrashedJobListener
    extends AbstractJobListener {
        JobCrashedJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            block5: {
                if (JobRegistry.getInstance().isShutdown(FailoverListenerManager.this.jobName) || !FailoverListenerManager.this.isFailoverEnabled() || CuratorCacheListener.Type.NODE_DELETED != eventType || !FailoverListenerManager.this.instanceNode.isInstancePath(path)) break block5;
                String jobInstanceId = path.substring(FailoverListenerManager.this.instanceNode.getInstanceFullPath().length() + 1);
                if (jobInstanceId.equals(JobRegistry.getInstance().getJobInstance(FailoverListenerManager.this.jobName).getJobInstanceId())) {
                    return;
                }
                List<Integer> failoverItems = FailoverListenerManager.this.failoverService.getFailoverItems(jobInstanceId);
                if (!failoverItems.isEmpty()) {
                    for (int each : failoverItems) {
                        FailoverListenerManager.this.failoverService.setCrashedFailoverFlag(each);
                        FailoverListenerManager.this.failoverService.failoverIfNecessary();
                    }
                } else {
                    for (int each : FailoverListenerManager.this.shardingService.getShardingItems(jobInstanceId)) {
                        FailoverListenerManager.this.failoverService.setCrashedFailoverFlag(each);
                        FailoverListenerManager.this.failoverService.failoverIfNecessary();
                    }
                }
            }
        }
    }
}

