/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.election;

import java.util.Objects;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.lite.internal.election.LeaderNode;
import org.apache.shardingsphere.elasticjob.lite.internal.election.LeaderService;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerNode;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerService;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerStatus;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ElectionListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final LeaderNode leaderNode;
    private final ServerNode serverNode;
    private final LeaderService leaderService;
    private final ServerService serverService;

    public ElectionListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.leaderNode = new LeaderNode(jobName);
        this.serverNode = new ServerNode(jobName);
        this.leaderService = new LeaderService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new LeaderElectionJobListener());
        this.addDataListener(new LeaderAbdicationJobListener());
    }

    class LeaderAbdicationJobListener
    extends AbstractJobListener {
        LeaderAbdicationJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (ElectionListenerManager.this.leaderService.isLeader() && this.isLocalServerDisabled(path, data)) {
                ElectionListenerManager.this.leaderService.removeLeader();
            }
        }

        private boolean isLocalServerDisabled(String path, String data) {
            return ElectionListenerManager.this.serverNode.isLocalServerPath(path) && ServerStatus.DISABLED.name().equals(data);
        }
    }

    class LeaderElectionJobListener
    extends AbstractJobListener {
        LeaderElectionJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (!JobRegistry.getInstance().isShutdown(ElectionListenerManager.this.jobName) && (this.isActiveElection(path, data) || this.isPassiveElection(path, eventType))) {
                ElectionListenerManager.this.leaderService.electLeader();
            }
        }

        private boolean isActiveElection(String path, String data) {
            return !ElectionListenerManager.this.leaderService.hasLeader() && this.isLocalServerEnabled(path, data);
        }

        private boolean isPassiveElection(String path, CuratorCacheListener.Type eventType) {
            JobInstance jobInstance = JobRegistry.getInstance().getJobInstance(ElectionListenerManager.this.jobName);
            return !Objects.isNull(jobInstance) && this.isLeaderCrashed(path, eventType) && ElectionListenerManager.this.serverService.isAvailableServer(jobInstance.getIp());
        }

        private boolean isLeaderCrashed(String path, CuratorCacheListener.Type eventType) {
            return ElectionListenerManager.this.leaderNode.isLeaderInstancePath(path) && CuratorCacheListener.Type.NODE_DELETED == eventType;
        }

        private boolean isLocalServerEnabled(String path, String data) {
            return ElectionListenerManager.this.serverNode.isLocalServerPath(path) && !ServerStatus.DISABLED.name().equals(data);
        }
    }
}

