/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.StackMapEntry;

public final class StackMap
extends Attribute {
    private int map_length;
    private StackMapEntry[] map;

    public StackMap(int n, int n2, StackMapEntry[] stackMapEntryArray, ConstantPool constantPool) {
        super((byte)11, n, n2, constantPool);
        this.setStackMap(stackMapEntryArray);
    }

    StackMap(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (StackMapEntry[])null, constantPool);
        this.map_length = dataInputStream.readUnsignedShort();
        this.map = new StackMapEntry[this.map_length];
        for (int i = 0; i < this.map_length; ++i) {
            this.map[i] = new StackMapEntry(dataInputStream, constantPool);
        }
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.map_length);
        for (int i = 0; i < this.map_length; ++i) {
            this.map[i].dump(dataOutputStream);
        }
    }

    public final StackMapEntry[] getStackMap() {
        return this.map;
    }

    public final void setStackMap(StackMapEntry[] stackMapEntryArray) {
        this.map = stackMapEntryArray;
        this.map_length = stackMapEntryArray == null ? 0 : stackMapEntryArray.length;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMap(");
        for (int i = 0; i < this.map_length; ++i) {
            stringBuffer.append(this.map[i].toString());
            if (i >= this.map_length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitStackMap(this);
    }

    public final int getMapLength() {
        return this.map_length;
    }
}

