/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.web.controller;

import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.ui.service.JobAPIService;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResult;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/jobs/config"})
public final class JobConfigController {
    private JobAPIService jobAPIService;

    @Autowired
    public JobConfigController(JobAPIService jobAPIService) {
        this.jobAPIService = jobAPIService;
    }

    @GetMapping(value={"/{jobName:.+}"})
    public ResponseResult<JobConfigurationPOJO> getJobConfig(@PathVariable(value="jobName") String jobName) {
        JobConfigurationPOJO data = this.jobAPIService.getJobConfigurationAPI().getJobConfiguration(jobName);
        return ResponseResultUtil.build(data);
    }

    @PutMapping
    public ResponseResult<Boolean> updateJobConfig(@RequestBody JobConfigurationPOJO jobConfiguration) {
        this.jobAPIService.getJobConfigurationAPI().updateJobConfiguration(jobConfiguration);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @DeleteMapping(value={"/{jobName:.+}"})
    public ResponseResult<Boolean> removeJob(@PathVariable(value="jobName") String jobName) {
        this.jobAPIService.getJobConfigurationAPI().removeJobConfiguration(jobName);
        return ResponseResultUtil.build(Boolean.TRUE);
    }
}

