/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.web.controller;

import java.sql.Driver;
import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.EventTraceDataSourceConfiguration;
import org.apache.shardingsphere.elasticjob.lite.ui.domain.EventTraceDataSourceFactory;
import org.apache.shardingsphere.elasticjob.lite.ui.service.EventTraceDataSourceConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.ui.util.SessionEventTraceDataSourceConfiguration;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResult;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/data-source"})
public final class EventTraceDataSourceController {
    public static final String DATA_SOURCE_CONFIG_KEY = "data_source_config_key";
    private final EventTraceDataSourceConfigurationService eventTraceDataSourceConfigurationService;

    @Autowired
    public EventTraceDataSourceController(EventTraceDataSourceConfigurationService eventTraceDataSourceConfigurationService) {
        this.eventTraceDataSourceConfigurationService = eventTraceDataSourceConfigurationService;
    }

    @GetMapping(value={"/drivers"})
    public ResponseResult<Collection<String>> availableDrivers() {
        HashSet result = new HashSet();
        ServiceLoader.load(Driver.class).forEach(each -> result.add(each.getClass().getName()));
        return ResponseResultUtil.build(result);
    }

    @GetMapping(value={"/activated"})
    public boolean activated(HttpServletRequest request) {
        return this.eventTraceDataSourceConfigurationService.loadActivated().isPresent();
    }

    @GetMapping(value={"/load"})
    public ResponseResult<Collection<EventTraceDataSourceConfiguration>> load(HttpServletRequest request) {
        this.eventTraceDataSourceConfigurationService.loadActivated().ifPresent(eventTraceDataSourceConfig -> this.setDataSourceNameToSession((EventTraceDataSourceConfiguration)eventTraceDataSourceConfig, request.getSession()));
        return ResponseResultUtil.build(this.eventTraceDataSourceConfigurationService.loadAll().getEventTraceDataSourceConfiguration());
    }

    @PostMapping(value={"/add"})
    public ResponseResult<Boolean> add(@RequestBody EventTraceDataSourceConfiguration config) {
        return ResponseResultUtil.build(this.eventTraceDataSourceConfigurationService.add(config));
    }

    @DeleteMapping
    public ResponseResult delete(@RequestBody EventTraceDataSourceConfiguration config) {
        this.eventTraceDataSourceConfigurationService.delete(config.getName());
        return ResponseResultUtil.success();
    }

    @PostMapping(value={"/connectTest"})
    public ResponseResult<Boolean> connectTest(@RequestBody EventTraceDataSourceConfiguration config, HttpServletRequest request) {
        this.setDataSourceNameToSession(config, request.getSession());
        return ResponseResultUtil.build(true);
    }

    @PostMapping(value={"/connect"})
    public ResponseResult<Boolean> connect(@RequestBody EventTraceDataSourceConfiguration config, HttpServletRequest request) {
        this.setDataSourceNameToSession(this.eventTraceDataSourceConfigurationService.find(config.getName(), this.eventTraceDataSourceConfigurationService.loadAll()), request.getSession());
        this.eventTraceDataSourceConfigurationService.load(config.getName());
        return ResponseResultUtil.build(true);
    }

    private void setDataSourceNameToSession(EventTraceDataSourceConfiguration dataSourceConfig, HttpSession session) {
        session.setAttribute(DATA_SOURCE_CONFIG_KEY, (Object)dataSourceConfig);
        EventTraceDataSourceFactory.createEventTraceDataSource(dataSourceConfig.getDriver(), dataSourceConfig.getUrl(), dataSourceConfig.getUsername(), dataSourceConfig.getPassword());
        SessionEventTraceDataSourceConfiguration.setDataSourceConfiguration((EventTraceDataSourceConfiguration)session.getAttribute(DATA_SOURCE_CONFIG_KEY));
    }
}

