/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.BinaryOpExpState;
import org.apache.openjpa.jdbc.kernel.exps.Exp;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.kernel.exps.WhenCondition;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Raw;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;

public class GeneralCaseExpression
extends AbstractVal {
    private static final long serialVersionUID = 1L;
    private final Exp[] _exp;
    private final Val _val;
    private ClassMetaData _meta = null;
    private Class _cast = null;
    private Value other = null;
    private ExpState otherState = null;

    public GeneralCaseExpression(Exp[] exp, Val val) {
        this._exp = exp;
        this._val = val;
    }

    public Exp[] getExp() {
        return this._exp;
    }

    public Val getVal() {
        return this._val;
    }

    @Override
    public Class getType() {
        if (this._cast != null) {
            return this._cast;
        }
        Class<?> type = this._val.getType();
        for (int i = 0; i < this._exp.length; ++i) {
            type = Filters.promote(type, ((WhenCondition)this._exp[i]).getVal().getType());
        }
        if (type == Raw.class) {
            return String.class;
        }
        return type;
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        int i;
        ExpState[] states = new ExpState[this._exp.length + 1];
        Joins joins = null;
        for (i = 0; i < this._exp.length; ++i) {
            states[i] = this._exp[i].initialize(sel, ctx, null);
            joins = joins == null ? states[i].joins : sel.and(joins, states[i].joins);
        }
        states[i] = this._val.initialize(sel, ctx, 0);
        joins = joins == null ? states[i].joins : sel.and(joins, states[i].joins);
        return new GeneralCaseExpState(joins, states);
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer buf, int index) {
        int i;
        GeneralCaseExpState cstate = (GeneralCaseExpState)state;
        buf.append(" CASE ");
        for (i = 0; i < this._exp.length; ++i) {
            this._exp[i].appendTo(sel, ctx, cstate.states[i], buf);
        }
        buf.append(" ELSE ");
        this._val.appendTo(sel, ctx, cstate.states[i], buf, 0);
        buf.append(" END ");
    }

    @Override
    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        int i;
        GeneralCaseExpState cstate = (GeneralCaseExpState)state;
        for (i = 0; i < this._exp.length; ++i) {
            this._exp[i].selectColumns(sel, ctx, cstate.states[i], pks);
        }
        this._val.selectColumns(sel, ctx, cstate.states[i], pks);
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        for (int i = 0; i < this._exp.length; ++i) {
            this._exp[i].acceptVisit(visitor);
        }
        this._val.acceptVisit(visitor);
        visitor.exit(this);
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        GeneralCaseExpState gstate = (GeneralCaseExpState)state;
        for (int i = 0; i < this._exp.length; ++i) {
            BinaryOpExpState bstate = (BinaryOpExpState)gstate.states[i];
            ((WhenCondition)this._exp[i]).getVal().calculateValue(sel, ctx, bstate.state2, other, otherState);
        }
        this._val.calculateValue(sel, ctx, gstate.states[this._exp.length], other, otherState);
    }

    @Override
    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        sel.groupBy(this.newSQLBuffer(sel, ctx, state));
    }

    @Override
    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    private SQLBuffer newSQLBuffer(Select sel, ExpContext ctx, ExpState state) {
        this.calculateValue(sel, ctx, state, (Val)this.other, this.otherState);
        SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
        this.appendTo(sel, ctx, state, buf, 0);
        return buf;
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return Filters.convert(res.getObject(this, 1012, null), this.getType());
    }

    @Override
    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.newSQLBuffer(sel, ctx, state), asc, false, this.getSelectAs());
    }

    @Override
    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.select(this.newSQLBuffer(sel, ctx, state), (Object)this);
    }

    @Override
    public ClassMetaData getMetaData() {
        return this._meta;
    }

    @Override
    public void setImplicitType(Class type) {
        this._cast = type;
    }

    @Override
    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    public void setOtherPath(Value other) {
        this.other = other;
    }

    public Value getOtherPath() {
        return this.other;
    }

    public void setOtherState(ExpState otherState) {
        this.otherState = otherState;
    }

    public ExpState getOtherState() {
        return this.otherState;
    }

    private static class GeneralCaseExpState
    extends ExpState {
        public ExpState[] states;

        public GeneralCaseExpState(Joins joins, ExpState[] states) {
            super(joins);
            this.states = states;
        }
    }
}

