/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashSet;
import org.apache.openjpa.util.UserException;

public class PCRegistry {
    private static final Localizer _loc = Localizer.forPackage(PCRegistry.class);
    private static final Map<Class<?>, Meta> _metas = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    private static final Collection<RegisterClassListener> _listeners = new ConcurrentReferenceHashSet<RegisterClassListener>(AbstractReferenceMap.ReferenceStrength.WEAK);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegisterClassListener(RegisterClassListener rcl) {
        if (rcl == null) {
            return;
        }
        Object object = _listeners;
        synchronized (object) {
            _listeners.add(rcl);
        }
        object = _metas;
        synchronized (object) {
            for (Class<?> cls : _metas.keySet()) {
                rcl.register(cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeRegisterClassListener(RegisterClassListener rcl) {
        Collection<RegisterClassListener> collection = _listeners;
        synchronized (collection) {
            return _listeners.remove(rcl);
        }
    }

    public static String[] getFieldNames(Class<?> pcClass) {
        Meta meta = PCRegistry.getMeta(pcClass);
        return meta.fieldNames;
    }

    public static Class<?>[] getFieldTypes(Class<?> pcClass) {
        Meta meta = PCRegistry.getMeta(pcClass);
        return meta.fieldTypes;
    }

    public static Class<?> getPersistentSuperclass(Class<?> pcClass) {
        Meta meta = PCRegistry.getMeta(pcClass);
        return meta.pcSuper;
    }

    public static PersistenceCapable newInstance(Class<?> pcClass, StateManager sm, boolean clear) {
        Meta meta = PCRegistry.getMeta(pcClass);
        return meta.pc == null ? null : meta.pc.pcNewInstance(sm, clear);
    }

    public static PersistenceCapable newInstance(Class<?> pcClass, StateManager sm, Object oid, boolean clear) {
        Meta meta = PCRegistry.getMeta(pcClass);
        return meta.pc == null ? null : meta.pc.pcNewInstance(sm, oid, clear);
    }

    public static Class<?> getPCType(Class<?> type) {
        Meta meta = PCRegistry.getMeta(type);
        return meta.pc == null ? null : meta.pc.getClass();
    }

    public static Object newObjectId(Class<?> pcClass) {
        Meta meta = PCRegistry.getMeta(pcClass);
        return meta.pc == null ? null : meta.pc.pcNewObjectIdInstance();
    }

    public static Object newObjectId(Class<?> pcClass, String str) {
        Meta meta = PCRegistry.getMeta(pcClass);
        return meta.pc == null ? null : meta.pc.pcNewObjectIdInstance(str);
    }

    public static String getTypeAlias(Class<?> pcClass) {
        return PCRegistry.getMeta(pcClass).alias;
    }

    public static void copyKeyFieldsToObjectId(Class<?> pcClass, FieldSupplier fm, Object oid) {
        Meta meta = PCRegistry.getMeta(pcClass);
        if (meta.pc == null) {
            throw new UserException(_loc.get("copy-no-id", pcClass));
        }
        meta.pc.pcCopyKeyFieldsToObjectId(fm, oid);
    }

    public static void copyKeyFieldsFromObjectId(Class<?> pcClass, FieldConsumer fm, Object oid) {
        Meta meta = PCRegistry.getMeta(pcClass);
        if (meta.pc == null) {
            throw new UserException(_loc.get("copy-no-id", pcClass));
        }
        meta.pc.pcCopyKeyFieldsFromObjectId(fm, oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Class<?> pcClass, String[] fieldNames, Class<?>[] fieldTypes, byte[] fieldFlags, Class<?> sup, String alias, PersistenceCapable pc) {
        if (pcClass == null) {
            throw new NullPointerException();
        }
        Meta meta = new Meta(pc, fieldNames, fieldTypes, sup, alias);
        Object object = _metas;
        synchronized (object) {
            _metas.put(pcClass, meta);
        }
        object = _listeners;
        synchronized (object) {
            for (RegisterClassListener r : _listeners) {
                if (r == null) continue;
                r.register(pcClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deRegister(ClassLoader cl) {
        Map<Class<?>, Meta> map = _metas;
        synchronized (map) {
            for (Class<?> pcClass : _metas.keySet()) {
                if (pcClass.getClassLoader() != cl) continue;
                _metas.remove(pcClass);
            }
        }
    }

    public static Collection<Class<?>> getRegisteredTypes() {
        return Collections.unmodifiableCollection(_metas.keySet());
    }

    public static boolean isRegistered(Class<?> cls) {
        return _metas.containsKey(cls);
    }

    private static Meta getMeta(Class<?> pcClass) {
        Meta ret = _metas.get(pcClass);
        if (ret == null) {
            throw new IllegalStateException(_loc.get("no-meta", pcClass).getMessage());
        }
        return ret;
    }

    private static class Meta {
        public final PersistenceCapable pc;
        public final String[] fieldNames;
        public final Class<?>[] fieldTypes;
        public final Class<?> pcSuper;
        public final String alias;

        public Meta(PersistenceCapable pc, String[] fieldNames, Class<?>[] fieldTypes, Class<?> pcSuper, String alias) {
            this.pc = pc;
            this.fieldNames = fieldNames;
            this.fieldTypes = fieldTypes;
            this.pcSuper = pcSuper;
            this.alias = alias;
        }
    }

    public static interface RegisterClassListener {
        public void register(Class<?> var1);
    }
}

