/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.type.MethodsMetadata;
import org.springframework.data.type.classreading.MethodsMetadataReader;
import org.springframework.data.type.classreading.MethodsMetadataReaderFactory;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class DefaultProjectionInformation
implements ProjectionInformation {
    private final Class<?> projectionType;
    private final List<PropertyDescriptor> properties;

    DefaultProjectionInformation(Class<?> type) {
        Assert.notNull(type, (String)"Projection type must not be null!");
        this.projectionType = type;
        this.properties = DefaultProjectionInformation.collectDescriptors(type);
    }

    @Override
    public Class<?> getType() {
        return this.projectionType;
    }

    @Override
    public List<PropertyDescriptor> getInputProperties() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : this.properties) {
            if (!this.isInputProperty(descriptor)) continue;
            result.add(descriptor);
        }
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.properties.equals(this.getInputProperties());
    }

    protected boolean isInputProperty(PropertyDescriptor descriptor) {
        return true;
    }

    private static List<PropertyDescriptor> collectDescriptors(Class<?> type) {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        MethodsMetadata metadata = DefaultProjectionInformation.getMetadata(type);
        final Map<String, Integer> orders = DefaultProjectionInformation.getMethodOrder(metadata);
        for (PropertyDescriptor descriptor : DefaultProjectionInformation.filterDefaultMethods(BeanUtils.getPropertyDescriptors(type))) {
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null || metadata != null && !orders.containsKey(readMethod.getName())) continue;
            result.add(descriptor);
        }
        if (metadata == null) {
            return result;
        }
        Collections.sort(result, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor left, PropertyDescriptor right) {
                return (Integer)orders.get(left.getReadMethod().getName()) - (Integer)orders.get(right.getReadMethod().getName());
            }
        });
        for (String name : metadata.getInterfaceNames()) {
            result.addAll(DefaultProjectionInformation.collectDescriptors(DefaultProjectionInformation.loadClass(name, type.getClassLoader())));
        }
        return result;
    }

    private static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return ClassUtils.forName((String)className, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Cannot load class %s", className));
        }
    }

    private static Map<String, Integer> getMethodOrder(MethodsMetadata metadata) {
        if (metadata == null) {
            return Collections.emptyMap();
        }
        Set<MethodMetadata> methods = metadata.getMethods();
        HashMap<String, Integer> result = new HashMap<String, Integer>(methods.size());
        int i = 0;
        for (MethodMetadata methodMetadata : methods) {
            String name = methodMetadata.getMethodName();
            if (result.containsKey(name)) continue;
            result.put(name, i++);
        }
        return result;
    }

    private static MethodsMetadata getMetadata(Class<?> type) {
        try {
            MethodsMetadataReaderFactory factory = new MethodsMetadataReaderFactory(type.getClassLoader());
            MethodsMetadataReader metadataReader = factory.getMetadataReader(ClassUtils.getQualifiedName(type));
            return metadataReader.getMethodsMetadata();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static List<PropertyDescriptor> filterDefaultMethods(PropertyDescriptor[] descriptors) {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            if (DefaultProjectionInformation.hasDefaultGetter(descriptor)) continue;
            result.add(descriptor);
        }
        return result;
    }

    private static boolean hasDefaultGetter(PropertyDescriptor descriptor) {
        Method method = descriptor.getReadMethod();
        return method != null && ReflectionUtils.isDefaultMethod(method);
    }
}

