/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.job;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class CloudJobDisableListener
implements CuratorCacheListener {
    private final CoordinatorRegistryCenter regCenter;
    private final ProducerManager producerManager;

    public CloudJobDisableListener(CoordinatorRegistryCenter regCenter, ProducerManager producerManager) {
        this.regCenter = regCenter;
        this.producerManager = producerManager;
    }

    public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
        String jobName;
        String path;
        String string = path = CuratorCacheListener.Type.NODE_DELETED == type ? oldData.getPath() : data.getPath();
        if (CuratorCacheListener.Type.NODE_CREATED == type && this.isJobDisableNode(path)) {
            String jobName2 = path.substring("/state/disable/job".length() + 1);
            if (Objects.nonNull(jobName2)) {
                this.producerManager.unschedule(jobName2);
            }
        } else if (CuratorCacheListener.Type.NODE_DELETED == type && this.isJobDisableNode(path) && Objects.nonNull(jobName = path.substring("/state/disable/job".length() + 1))) {
            this.producerManager.reschedule(jobName);
        }
    }

    private boolean isJobDisableNode(String path) {
        return path.startsWith("/state/disable/job") && path.length() > "/state/disable/job".length();
    }

    public void start() {
        this.getCache().listenable().addListener((Object)this, (Executor)Executors.newSingleThreadExecutor());
    }

    public void stop() {
        this.getCache().listenable().removeListener((Object)this);
    }

    private CuratorCache getCache() {
        CuratorCache result = (CuratorCache)this.regCenter.getRawCache("/state/disable/job");
        if (null != result) {
            return result;
        }
        this.regCenter.addCacheData("/state/disable/job");
        return (CuratorCache)this.regCenter.getRawCache("/state/disable/job");
    }
}

