/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AutoScaleRules;
import com.netflix.fenzo.ShortfallEvaluator;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskSchedulingService;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.queues.QueuableTask;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

abstract class BaseShortfallEvaluator
implements ShortfallEvaluator {
    private static final long TOO_OLD_THRESHOLD_MILLIS = 600000L;
    private volatile Func1<QueuableTask, List<String>> taskToClustersGetter = null;
    private final Map<String, Long> requestedForTasksSet = new HashMap<String, Long>();
    protected TaskSchedulingService schedulingService = null;

    BaseShortfallEvaluator() {
    }

    @Override
    public void setTaskToClustersGetter(Func1<QueuableTask, List<String>> getter) {
        this.taskToClustersGetter = getter;
    }

    @Override
    public abstract Map<String, Integer> getShortfall(Set<String> var1, Set<TaskRequest> var2, AutoScaleRules var3);

    @Override
    public void setTaskSchedulingService(TaskSchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    protected void reset() {
        long tooOld = System.currentTimeMillis() - 600000L;
        HashSet<String> tasks = new HashSet<String>(this.requestedForTasksSet.keySet());
        for (String t : tasks) {
            if (this.requestedForTasksSet.get(t) >= tooOld) continue;
            this.requestedForTasksSet.remove(t);
        }
    }

    protected List<TaskRequest> filterFailedTasks(Collection<TaskRequest> original) {
        if (original == null || original.isEmpty()) {
            return Collections.emptyList();
        }
        long now = System.currentTimeMillis();
        return original.stream().filter(t -> this.requestedForTasksSet.putIfAbsent(t.getId(), now) == null).collect(Collectors.toList());
    }

    protected Map<String, Integer> fillShortfallMap(Set<String> attrKeys, Collection<TaskRequest> requests) {
        HashMap<String, Integer> shortfallMap = new HashMap<String, Integer>();
        if (requests != null && !requests.isEmpty()) {
            for (TaskRequest r : requests) {
                for (String k : attrKeys) {
                    if (!this.matchesTask(r, k)) continue;
                    if (shortfallMap.get(k) == null) {
                        shortfallMap.put(k, 1);
                        continue;
                    }
                    shortfallMap.put(k, (Integer)shortfallMap.get(k) + 1);
                }
            }
        }
        return shortfallMap;
    }

    private boolean matchesTask(TaskRequest r, String k) {
        if (!(r instanceof QueuableTask) || this.taskToClustersGetter == null) {
            return true;
        }
        List<String> strings = this.taskToClustersGetter.call((QueuableTask)r);
        if (strings != null && !strings.isEmpty()) {
            for (String s : strings) {
                if (!k.equals(s)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

