/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.failover;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationNode;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.failover.FailoverService;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceNode;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class FailoverListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final FailoverService failoverService;
    private final ExecutionService executionService;
    private final InstanceService instanceService;
    private final ConfigurationNode configNode;
    private final InstanceNode instanceNode;

    public FailoverListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
        this.instanceNode = new InstanceNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new JobCrashedJobListener());
        this.addDataListener(new FailoverSettingsChangedJobListener());
        this.addDataListener(new LegacyCrashedRunningItemListener());
    }

    private boolean isFailoverEnabled() {
        return this.configService.load(true).isFailover();
    }

    class JobCrashedJobListener
    implements DataChangedEventListener {
        JobCrashedJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            block5: {
                if (JobRegistry.getInstance().isShutdown(FailoverListenerManager.this.jobName) || !FailoverListenerManager.this.isFailoverEnabled() || DataChangedEvent.Type.DELETED != event.getType() || !FailoverListenerManager.this.instanceNode.isInstancePath(event.getKey())) break block5;
                String jobInstanceId = event.getKey().substring(FailoverListenerManager.this.instanceNode.getInstanceFullPath().length() + 1);
                if (jobInstanceId.equals(JobRegistry.getInstance().getJobInstance(FailoverListenerManager.this.jobName).getJobInstanceId())) {
                    return;
                }
                List<Integer> failoverItems = FailoverListenerManager.this.failoverService.getFailoveringItems(jobInstanceId);
                if (!failoverItems.isEmpty()) {
                    for (int each : failoverItems) {
                        FailoverListenerManager.this.failoverService.setCrashedFailoverFlagDirectly(each);
                        FailoverListenerManager.this.failoverService.failoverIfNecessary();
                    }
                } else {
                    for (int each : FailoverListenerManager.this.shardingService.getCrashedShardingItems(jobInstanceId)) {
                        FailoverListenerManager.this.failoverService.setCrashedFailoverFlag(each);
                        FailoverListenerManager.this.failoverService.failoverIfNecessary();
                    }
                }
            }
        }
    }

    class FailoverSettingsChangedJobListener
    implements DataChangedEventListener {
        FailoverSettingsChangedJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (FailoverListenerManager.this.configNode.isConfigPath(event.getKey()) && DataChangedEvent.Type.UPDATED == event.getType() && !((JobConfigurationPOJO)YamlEngine.unmarshal((String)event.getValue(), JobConfigurationPOJO.class)).toJobConfiguration().isFailover()) {
                FailoverListenerManager.this.failoverService.removeFailoverInfo();
            }
        }
    }

    class LegacyCrashedRunningItemListener
    implements DataChangedEventListener {
        LegacyCrashedRunningItemListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (!this.isCurrentInstanceOnline(event) || !FailoverListenerManager.this.isFailoverEnabled()) {
                return;
            }
            HashSet<JobInstance> availableJobInstances = new HashSet<JobInstance>(FailoverListenerManager.this.instanceService.getAvailableJobInstances());
            if (!this.isTheOnlyInstance(availableJobInstances)) {
                return;
            }
            Map<Integer, JobInstance> allRunningItems = FailoverListenerManager.this.executionService.getAllRunningItems();
            Map<Integer, JobInstance> allFailoveringItems = FailoverListenerManager.this.failoverService.getAllFailoveringItems();
            if (allRunningItems.isEmpty() && allFailoveringItems.isEmpty()) {
                return;
            }
            for (Map.Entry<Integer, JobInstance> entry : allFailoveringItems.entrySet()) {
                if (availableJobInstances.contains(entry.getValue())) continue;
                int item = entry.getKey();
                FailoverListenerManager.this.failoverService.setCrashedFailoverFlagDirectly(item);
                FailoverListenerManager.this.failoverService.clearFailoveringItem(item);
                FailoverListenerManager.this.executionService.clearRunningInfo(Collections.singletonList(item));
                allRunningItems.remove(item);
            }
            for (Map.Entry<Integer, JobInstance> entry : allRunningItems.entrySet()) {
                if (availableJobInstances.contains(entry.getValue())) continue;
                FailoverListenerManager.this.failoverService.setCrashedFailoverFlag(entry.getKey());
                FailoverListenerManager.this.executionService.clearRunningInfo(Collections.singletonList(entry.getKey()));
            }
            FailoverListenerManager.this.failoverService.failoverIfNecessary();
        }

        private boolean isCurrentInstanceOnline(DataChangedEvent event) {
            return DataChangedEvent.Type.ADDED == event.getType() && !JobRegistry.getInstance().isShutdown(FailoverListenerManager.this.jobName) && event.getKey().endsWith(FailoverListenerManager.this.instanceNode.getLocalInstancePath());
        }

        private boolean isTheOnlyInstance(Set<JobInstance> availableJobInstances) {
            return Collections.singleton(JobRegistry.getInstance().getJobInstance(FailoverListenerManager.this.jobName)).equals(availableJobInstances);
        }
    }
}

