/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.executor.prod;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.facade.CloudJobFacade;
import org.apache.shardingsphere.elasticjob.executor.ElasticJobExecutor;
import org.apache.shardingsphere.elasticjob.executor.JobFacade;
import org.apache.shardingsphere.elasticjob.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.infra.listener.ShardingContexts;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.plugins.management.ShutdownHookPlugin;
import org.quartz.simpl.SimpleThreadPool;

public final class DaemonTaskScheduler {
    private static final String ELASTIC_JOB_DATA_MAP_KEY = "elasticJob";
    private static final String ELASTIC_JOB_TYPE_DATA_MAP_KEY = "elasticJobType";
    private static final String JOB_FACADE_DATA_MAP_KEY = "jobFacade";
    private static final String EXECUTOR_DRIVER_DATA_MAP_KEY = "executorDriver";
    private static final String TASK_ID_DATA_MAP_KEY = "taskId";
    private static final ConcurrentHashMap<String, Scheduler> RUNNING_SCHEDULERS = new ConcurrentHashMap(1024, 1.0f);
    private final ElasticJob elasticJob;
    private final String elasticJobType;
    private final JobConfiguration jobConfig;
    private final JobFacade jobFacade;
    private final ExecutorDriver executorDriver;
    private final Protos.TaskID taskId;

    public void init() {
        JobDetail jobDetail = JobBuilder.newJob(DaemonJob.class).withIdentity(this.jobConfig.getJobName()).build();
        jobDetail.getJobDataMap().put(ELASTIC_JOB_DATA_MAP_KEY, (Object)this.elasticJob);
        jobDetail.getJobDataMap().put(ELASTIC_JOB_TYPE_DATA_MAP_KEY, this.elasticJobType);
        jobDetail.getJobDataMap().put(JOB_FACADE_DATA_MAP_KEY, (Object)this.jobFacade);
        jobDetail.getJobDataMap().put(EXECUTOR_DRIVER_DATA_MAP_KEY, (Object)this.executorDriver);
        jobDetail.getJobDataMap().put(TASK_ID_DATA_MAP_KEY, (Object)this.taskId);
        try {
            this.scheduleJob(this.initializeScheduler(), jobDetail, this.taskId.getValue(), this.jobConfig.getCron());
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private Scheduler initializeScheduler() throws SchedulerException {
        StdSchedulerFactory factory = new StdSchedulerFactory();
        factory.initialize(this.getBaseQuartzProperties());
        return factory.getScheduler();
    }

    private Properties getBaseQuartzProperties() {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        result.put("org.quartz.threadPool.threadCount", "1");
        result.put("org.quartz.scheduler.instanceName", this.taskId.getValue());
        if (!this.jobConfig.isMisfire()) {
            result.put("org.quartz.jobStore.misfireThreshold", "1");
        }
        result.put("org.quartz.plugin.shutdownhook.class", ShutdownHookPlugin.class.getName());
        result.put("org.quartz.plugin.shutdownhook.cleanShutdown", Boolean.TRUE.toString());
        return result;
    }

    private void scheduleJob(Scheduler scheduler, JobDetail jobDetail, String triggerIdentity, String cron) {
        try {
            if (!scheduler.checkExists(jobDetail.getKey())) {
                scheduler.scheduleJob(jobDetail, (Trigger)this.createTrigger(triggerIdentity, cron));
            }
            scheduler.start();
            RUNNING_SCHEDULERS.putIfAbsent(scheduler.getSchedulerName(), scheduler);
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private CronTrigger createTrigger(String triggerIdentity, String cron) {
        return (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerIdentity).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron).withMisfireHandlingInstructionDoNothing()).build();
    }

    public static void shutdown(Protos.TaskID taskID) {
        Scheduler scheduler = RUNNING_SCHEDULERS.remove(taskID.getValue());
        if (null != scheduler) {
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException ex) {
                throw new JobSystemException((Throwable)ex);
            }
        }
    }

    @Generated
    public DaemonTaskScheduler(ElasticJob elasticJob, String elasticJobType, JobConfiguration jobConfig, JobFacade jobFacade, ExecutorDriver executorDriver, Protos.TaskID taskId) {
        this.elasticJob = elasticJob;
        this.elasticJobType = elasticJobType;
        this.jobConfig = jobConfig;
        this.jobFacade = jobFacade;
        this.executorDriver = executorDriver;
        this.taskId = taskId;
    }

    public static final class DaemonJob
    implements Job {
        private ElasticJob elasticJob;
        private String elasticJobType;
        private CloudJobFacade jobFacade;
        private ExecutorDriver executorDriver;
        private Protos.TaskID taskId;
        private volatile ElasticJobExecutor jobExecutor;

        public void execute(JobExecutionContext context) {
            ShardingContexts shardingContexts = this.jobFacade.getShardingContexts();
            int jobEventSamplingCount = shardingContexts.getJobEventSamplingCount();
            int currentJobEventSamplingCount = shardingContexts.getCurrentJobEventSamplingCount();
            if (jobEventSamplingCount > 0 && ++currentJobEventSamplingCount < jobEventSamplingCount) {
                shardingContexts.setCurrentJobEventSamplingCount(currentJobEventSamplingCount);
                this.jobFacade.getShardingContexts().setAllowSendJobEvent(false);
                this.getJobExecutor().execute();
            } else {
                this.jobFacade.getShardingContexts().setAllowSendJobEvent(true);
                this.executorDriver.sendStatusUpdate(Protos.TaskStatus.newBuilder().setTaskId(this.taskId).setState(Protos.TaskState.TASK_RUNNING).setMessage("BEGIN").build());
                this.getJobExecutor().execute();
                this.executorDriver.sendStatusUpdate(Protos.TaskStatus.newBuilder().setTaskId(this.taskId).setState(Protos.TaskState.TASK_RUNNING).setMessage("COMPLETE").build());
                shardingContexts.setCurrentJobEventSamplingCount(0);
            }
        }

        private ElasticJobExecutor getJobExecutor() {
            if (null == this.jobExecutor) {
                this.createJobExecutor();
            }
            return this.jobExecutor;
        }

        private synchronized void createJobExecutor() {
            if (null != this.jobExecutor) {
                return;
            }
            this.jobExecutor = null == this.elasticJob ? new ElasticJobExecutor(this.elasticJobType, this.jobFacade.loadJobConfiguration(true), (JobFacade)this.jobFacade) : new ElasticJobExecutor(this.elasticJob, this.jobFacade.loadJobConfiguration(true), (JobFacade)this.jobFacade);
        }

        @Generated
        public void setElasticJob(ElasticJob elasticJob) {
            this.elasticJob = elasticJob;
        }

        @Generated
        public void setElasticJobType(String elasticJobType) {
            this.elasticJobType = elasticJobType;
        }

        @Generated
        public void setJobFacade(CloudJobFacade jobFacade) {
            this.jobFacade = jobFacade;
        }

        @Generated
        public void setExecutorDriver(ExecutorDriver executorDriver) {
            this.executorDriver = executorDriver;
        }

        @Generated
        public void setTaskId(Protos.TaskID taskId) {
            this.taskId = taskId;
        }
    }
}

