/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.spring.boot.tracing;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.shardingsphere.elasticjob.lite.spring.boot.tracing.TracingProperties;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;

@EnableConfigurationProperties(value={TracingProperties.class})
public class ElasticJobTracingConfiguration {
    @Bean(value={"tracingDataSource"})
    public DataSource tracingDataSource(TracingProperties tracingProperties) {
        DataSourceProperties dataSource = tracingProperties.getDataSource();
        if (dataSource == null) {
            return null;
        }
        HikariDataSource tracingDataSource = new HikariDataSource();
        tracingDataSource.setJdbcUrl(dataSource.getUrl());
        BeanUtils.copyProperties((Object)dataSource, (Object)tracingDataSource);
        return tracingDataSource;
    }

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnProperty(name={"elasticjob.tracing.type"}, havingValue="RDB")
    public TracingConfiguration<DataSource> tracingConfiguration(DataSource dataSource, @Nullable DataSource tracingDataSource) {
        DataSource ds = tracingDataSource;
        if (ds == null) {
            ds = dataSource;
        }
        return new TracingConfiguration("RDB", (Object)ds);
    }
}

